// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the AI Services Vision parameters for vectorizing a query image or text.
 */
@Fluent
public final class AIServicesVisionVectorizer extends VectorSearchVectorizer {
    /*
     * The name of the kind of vectorization method being configured for use with vector search.
     */
    @Generated
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.AISERVICES_VISION;

    /*
     * Contains the parameters specific to AI Services Vision embedding vectorization.
     */
    @Generated
    private AIServicesVisionParameters aIServicesVisionParameters;

    /**
     * Creates an instance of AIServicesVisionVectorizer class.
     * 
     * @param vectorizerName the vectorizerName value to set.
     */
    @Generated
    public AIServicesVisionVectorizer(String vectorizerName) {
        super(vectorizerName);
    }

    /**
     * Get the kind property: The name of the kind of vectorization method being configured for use with vector search.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    /**
     * Get the aIServicesVisionParameters property: Contains the parameters specific to AI Services Vision embedding
     * vectorization.
     * 
     * @return the aIServicesVisionParameters value.
     */
    @Generated
    public AIServicesVisionParameters getAIServicesVisionParameters() {
        return this.aIServicesVisionParameters;
    }

    /**
     * Set the aIServicesVisionParameters property: Contains the parameters specific to AI Services Vision embedding
     * vectorization.
     * 
     * @param aIServicesVisionParameters the aIServicesVisionParameters value to set.
     * @return the AIServicesVisionVectorizer object itself.
     */
    @Generated
    public AIServicesVisionVectorizer
        setAIServicesVisionParameters(AIServicesVisionParameters aIServicesVisionParameters) {
        this.aIServicesVisionParameters = aIServicesVisionParameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getVectorizerName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("aiServicesVisionParameters", this.aIServicesVisionParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AIServicesVisionVectorizer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AIServicesVisionVectorizer if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AIServicesVisionVectorizer.
     */
    @Generated
    public static AIServicesVisionVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean vectorizerNameFound = false;
            String vectorizerName = null;
            VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.AISERVICES_VISION;
            AIServicesVisionParameters aIServicesVisionParameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    vectorizerName = reader.getString();
                    vectorizerNameFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = VectorSearchVectorizerKind.fromString(reader.getString());
                } else if ("aiServicesVisionParameters".equals(fieldName)) {
                    aIServicesVisionParameters = AIServicesVisionParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (vectorizerNameFound) {
                AIServicesVisionVectorizer deserializedAIServicesVisionVectorizer
                    = new AIServicesVisionVectorizer(vectorizerName);
                deserializedAIServicesVisionVectorizer.kind = kind;
                deserializedAIServicesVisionVectorizer.aIServicesVisionParameters = aIServicesVisionParameters;

                return deserializedAIServicesVisionVectorizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
