// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Configuration for Azure Blob Storage knowledge source.
 */
@Fluent
public final class AzureBlobKnowledgeSource extends KnowledgeSource {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.AZURE_BLOB;

    /*
     * The type of the knowledge source.
     */
    @Generated
    private final AzureBlobKnowledgeSourceParameters azureBlobParameters;

    /**
     * Creates an instance of AzureBlobKnowledgeSource class.
     * 
     * @param name the name value to set.
     * @param azureBlobParameters the azureBlobParameters value to set.
     */
    @Generated
    public AzureBlobKnowledgeSource(String name, AzureBlobKnowledgeSourceParameters azureBlobParameters) {
        super(name);
        this.azureBlobParameters = azureBlobParameters;
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the azureBlobParameters property: The type of the knowledge source.
     * 
     * @return the azureBlobParameters value.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters getAzureBlobParameters() {
        return this.azureBlobParameters;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AzureBlobKnowledgeSource setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AzureBlobKnowledgeSource setETag(String eTag) {
        super.setETag(eTag);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AzureBlobKnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        super.setEncryptionKey(encryptionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("@odata.etag", getETag());
        jsonWriter.writeJsonField("encryptionKey", getEncryptionKey());
        jsonWriter.writeJsonField("azureBlobParameters", this.azureBlobParameters);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureBlobKnowledgeSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureBlobKnowledgeSource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureBlobKnowledgeSource.
     */
    @Generated
    public static AzureBlobKnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            boolean azureBlobParametersFound = false;
            AzureBlobKnowledgeSourceParameters azureBlobParameters = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.AZURE_BLOB;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                } else if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                } else if ("azureBlobParameters".equals(fieldName)) {
                    azureBlobParameters = AzureBlobKnowledgeSourceParameters.fromJson(reader);
                    azureBlobParametersFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && azureBlobParametersFound) {
                AzureBlobKnowledgeSource deserializedAzureBlobKnowledgeSource
                    = new AzureBlobKnowledgeSource(name, azureBlobParameters);
                deserializedAzureBlobKnowledgeSource.setDescription(description);
                deserializedAzureBlobKnowledgeSource.setETag(eTag);
                deserializedAzureBlobKnowledgeSource.setEncryptionKey(encryptionKey);
                deserializedAzureBlobKnowledgeSource.kind = kind;

                return deserializedAzureBlobKnowledgeSource;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!azureBlobParametersFound) {
                missingProperties.add("azureBlobParameters");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
