// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Parameters for Azure Blob Storage knowledge source.
 */
@Fluent
public final class AzureBlobKnowledgeSourceParameters implements JsonSerializable<AzureBlobKnowledgeSourceParameters> {
    /*
     * Key-based connection string or the ResourceId format if using a managed identity.
     */
    @Generated
    private final String connectionString;

    /*
     * The name of the blob storage container.
     */
    @Generated
    private final String containerName;

    /*
     * Optional folder path within the container.
     */
    @Generated
    private String folderPath;

    /*
     * Set to true if connecting to an ADLS Gen2 storage account. Default is false.
     */
    @Generated
    private Boolean isAdlsGen2;

    /*
     * Consolidates all general ingestion settings.
     */
    @Generated
    private KnowledgeSourceIngestionParameters ingestionParameters;

    /*
     * Resources created by the knowledge source.
     */
    @Generated
    private Map<String, String> createdResources;

    /**
     * Creates an instance of AzureBlobKnowledgeSourceParameters class.
     * 
     * @param connectionString the connectionString value to set.
     * @param containerName the containerName value to set.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters(String connectionString, String containerName) {
        this.connectionString = connectionString;
        this.containerName = containerName;
    }

    /**
     * Get the connectionString property: Key-based connection string or the ResourceId format if using a managed
     * identity.
     * 
     * @return the connectionString value.
     */
    @Generated
    public String getConnectionString() {
        return this.connectionString;
    }

    /**
     * Get the containerName property: The name of the blob storage container.
     * 
     * @return the containerName value.
     */
    @Generated
    public String getContainerName() {
        return this.containerName;
    }

    /**
     * Get the folderPath property: Optional folder path within the container.
     * 
     * @return the folderPath value.
     */
    @Generated
    public String getFolderPath() {
        return this.folderPath;
    }

    /**
     * Set the folderPath property: Optional folder path within the container.
     * 
     * @param folderPath the folderPath value to set.
     * @return the AzureBlobKnowledgeSourceParameters object itself.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters setFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    /**
     * Get the isAdlsGen2 property: Set to true if connecting to an ADLS Gen2 storage account. Default is false.
     * 
     * @return the isAdlsGen2 value.
     */
    @Generated
    public Boolean isAdlsGen2() {
        return this.isAdlsGen2;
    }

    /**
     * Set the isAdlsGen2 property: Set to true if connecting to an ADLS Gen2 storage account. Default is false.
     * 
     * @param isAdlsGen2 the isAdlsGen2 value to set.
     * @return the AzureBlobKnowledgeSourceParameters object itself.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters setIsAdlsGen2(Boolean isAdlsGen2) {
        this.isAdlsGen2 = isAdlsGen2;
        return this;
    }

    /**
     * Get the ingestionParameters property: Consolidates all general ingestion settings.
     * 
     * @return the ingestionParameters value.
     */
    @Generated
    public KnowledgeSourceIngestionParameters getIngestionParameters() {
        return this.ingestionParameters;
    }

    /**
     * Set the ingestionParameters property: Consolidates all general ingestion settings.
     * 
     * @param ingestionParameters the ingestionParameters value to set.
     * @return the AzureBlobKnowledgeSourceParameters object itself.
     */
    @Generated
    public AzureBlobKnowledgeSourceParameters
        setIngestionParameters(KnowledgeSourceIngestionParameters ingestionParameters) {
        this.ingestionParameters = ingestionParameters;
        return this;
    }

    /**
     * Get the createdResources property: Resources created by the knowledge source.
     * 
     * @return the createdResources value.
     */
    @Generated
    public Map<String, String> getCreatedResources() {
        return this.createdResources;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeStringField("folderPath", this.folderPath);
        jsonWriter.writeBooleanField("isADLSGen2", this.isAdlsGen2);
        jsonWriter.writeJsonField("ingestionParameters", this.ingestionParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureBlobKnowledgeSourceParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureBlobKnowledgeSourceParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureBlobKnowledgeSourceParameters.
     */
    @Generated
    public static AzureBlobKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean connectionStringFound = false;
            String connectionString = null;
            boolean containerNameFound = false;
            String containerName = null;
            String folderPath = null;
            Boolean isAdlsGen2 = null;
            KnowledgeSourceIngestionParameters ingestionParameters = null;
            Map<String, String> createdResources = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectionString".equals(fieldName)) {
                    connectionString = reader.getString();
                    connectionStringFound = true;
                } else if ("containerName".equals(fieldName)) {
                    containerName = reader.getString();
                    containerNameFound = true;
                } else if ("folderPath".equals(fieldName)) {
                    folderPath = reader.getString();
                } else if ("isADLSGen2".equals(fieldName)) {
                    isAdlsGen2 = reader.getNullable(JsonReader::getBoolean);
                } else if ("ingestionParameters".equals(fieldName)) {
                    ingestionParameters = KnowledgeSourceIngestionParameters.fromJson(reader);
                } else if ("createdResources".equals(fieldName)) {
                    createdResources = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (connectionStringFound && containerNameFound) {
                AzureBlobKnowledgeSourceParameters deserializedAzureBlobKnowledgeSourceParameters
                    = new AzureBlobKnowledgeSourceParameters(connectionString, containerName);
                deserializedAzureBlobKnowledgeSourceParameters.folderPath = folderPath;
                deserializedAzureBlobKnowledgeSourceParameters.isAdlsGen2 = isAdlsGen2;
                deserializedAzureBlobKnowledgeSourceParameters.ingestionParameters = ingestionParameters;
                deserializedAzureBlobKnowledgeSourceParameters.createdResources = createdResources;

                return deserializedAzureBlobKnowledgeSourceParameters;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!connectionStringFound) {
                missingProperties.add("connectionString");
            }
            if (!containerNameFound) {
                missingProperties.add("containerName");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
