// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * Specifies the properties for connecting to an AML vectorizer.
 */
@Fluent
public final class AzureMachineLearningParameters implements JsonSerializable<AzureMachineLearningParameters> {
    /*
     * (Required for no authentication or key authentication) The scoring URI of the AML service to which the JSON
     * payload will be sent. Only the https URI scheme is allowed.
     */
    @Generated
    private final String scoringUri;

    /*
     * (Required for key authentication) The key for the AML service.
     */
    @Generated
    private String authenticationKey;

    /*
     * (Required for token authentication). The Azure Resource Manager resource ID of the AML service. It should be in
     * the format
     * subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace
     * -name}/services/{service_name}.
     */
    @Generated
    private String resourceId;

    /*
     * (Optional) When specified, indicates the timeout for the http client making the API call.
     */
    @Generated
    private Duration timeout;

    /*
     * (Optional for token authentication). The region the AML service is deployed in.
     */
    @Generated
    private String region;

    /*
     * The name of the embedding model from the Azure AI Foundry Catalog that is deployed at the provided endpoint.
     */
    @Generated
    private AIFoundryModelCatalogName modelName;

    /**
     * Creates an instance of AzureMachineLearningParameters class.
     * 
     * @param scoringUri the scoringUri value to set.
     */
    @Generated
    public AzureMachineLearningParameters(String scoringUri) {
        this.scoringUri = scoringUri;
    }

    /**
     * Get the scoringUri property: (Required for no authentication or key authentication) The scoring URI of the AML
     * service to which the JSON payload will be sent. Only the https URI scheme is allowed.
     * 
     * @return the scoringUri value.
     */
    @Generated
    public String getScoringUri() {
        return this.scoringUri;
    }

    /**
     * Get the authenticationKey property: (Required for key authentication) The key for the AML service.
     * 
     * @return the authenticationKey value.
     */
    @Generated
    public String getAuthenticationKey() {
        return this.authenticationKey;
    }

    /**
     * Set the authenticationKey property: (Required for key authentication) The key for the AML service.
     * 
     * @param authenticationKey the authenticationKey value to set.
     * @return the AzureMachineLearningParameters object itself.
     */
    @Generated
    public AzureMachineLearningParameters setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
        return this;
    }

    /**
     * Get the resourceId property: (Required for token authentication). The Azure Resource Manager resource ID of the
     * AML service. It should be in the format
     * subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}.
     * 
     * @return the resourceId value.
     */
    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: (Required for token authentication). The Azure Resource Manager resource ID of the
     * AML service. It should be in the format
     * subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}.
     * 
     * @param resourceId the resourceId value to set.
     * @return the AzureMachineLearningParameters object itself.
     */
    @Generated
    public AzureMachineLearningParameters setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the timeout property: (Optional) When specified, indicates the timeout for the http client making the API
     * call.
     * 
     * @return the timeout value.
     */
    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: (Optional) When specified, indicates the timeout for the http client making the API
     * call.
     * 
     * @param timeout the timeout value to set.
     * @return the AzureMachineLearningParameters object itself.
     */
    @Generated
    public AzureMachineLearningParameters setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the region property: (Optional for token authentication). The region the AML service is deployed in.
     * 
     * @return the region value.
     */
    @Generated
    public String getRegion() {
        return this.region;
    }

    /**
     * Set the region property: (Optional for token authentication). The region the AML service is deployed in.
     * 
     * @param region the region value to set.
     * @return the AzureMachineLearningParameters object itself.
     */
    @Generated
    public AzureMachineLearningParameters setRegion(String region) {
        this.region = region;
        return this;
    }

    /**
     * Get the modelName property: The name of the embedding model from the Azure AI Foundry Catalog that is deployed at
     * the provided endpoint.
     * 
     * @return the modelName value.
     */
    @Generated
    public AIFoundryModelCatalogName getModelName() {
        return this.modelName;
    }

    /**
     * Set the modelName property: The name of the embedding model from the Azure AI Foundry Catalog that is deployed at
     * the provided endpoint.
     * 
     * @param modelName the modelName value to set.
     * @return the AzureMachineLearningParameters object itself.
     */
    @Generated
    public AzureMachineLearningParameters setModelName(AIFoundryModelCatalogName modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.scoringUri);
        jsonWriter.writeStringField("key", this.authenticationKey);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays(this.timeout));
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("modelName", this.modelName == null ? null : this.modelName.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureMachineLearningParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureMachineLearningParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureMachineLearningParameters.
     */
    @Generated
    public static AzureMachineLearningParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean scoringUriFound = false;
            String scoringUri = null;
            String authenticationKey = null;
            String resourceId = null;
            Duration timeout = null;
            String region = null;
            AIFoundryModelCatalogName modelName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uri".equals(fieldName)) {
                    scoringUri = reader.getString();
                    scoringUriFound = true;
                } else if ("key".equals(fieldName)) {
                    authenticationKey = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    resourceId = reader.getString();
                } else if ("timeout".equals(fieldName)) {
                    timeout = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("region".equals(fieldName)) {
                    region = reader.getString();
                } else if ("modelName".equals(fieldName)) {
                    modelName = AIFoundryModelCatalogName.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (scoringUriFound) {
                AzureMachineLearningParameters deserializedAzureMachineLearningParameters
                    = new AzureMachineLearningParameters(scoringUri);
                deserializedAzureMachineLearningParameters.authenticationKey = authenticationKey;
                deserializedAzureMachineLearningParameters.resourceId = resourceId;
                deserializedAzureMachineLearningParameters.timeout = timeout;
                deserializedAzureMachineLearningParameters.region = region;
                deserializedAzureMachineLearningParameters.modelName = modelName;

                return deserializedAzureMachineLearningParameters;
            }
            throw new IllegalStateException("Missing required property: uri");
        });
    }
}
