// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Determines how the language model's response should be serialized. Defaults to 'text'.
 */
@Fluent
public final class ChatCompletionResponseFormat implements JsonSerializable<ChatCompletionResponseFormat> {
    /*
     * Specifies how the LLM should format the response. Possible values: 'text' (plain string), 'json_object'
     * (arbitrary JSON), or 'json_schema' (adheres to provided schema).
     */
    @Generated
    private ChatCompletionResponseFormatType type;

    /*
     * An open dictionary for extended properties. Required if 'type' == 'json_schema'
     */
    @Generated
    private ChatCompletionResponseFormatJsonSchemaProperties chatCompletionSchemaProperties;

    /**
     * Creates an instance of ChatCompletionResponseFormat class.
     */
    @Generated
    public ChatCompletionResponseFormat() {
    }

    /**
     * Get the type property: Specifies how the LLM should format the response. Possible values: 'text' (plain string),
     * 'json_object' (arbitrary JSON), or 'json_schema' (adheres to provided schema).
     * 
     * @return the type value.
     */
    @Generated
    public ChatCompletionResponseFormatType getType() {
        return this.type;
    }

    /**
     * Set the type property: Specifies how the LLM should format the response. Possible values: 'text' (plain string),
     * 'json_object' (arbitrary JSON), or 'json_schema' (adheres to provided schema).
     * 
     * @param type the type value to set.
     * @return the ChatCompletionResponseFormat object itself.
     */
    @Generated
    public ChatCompletionResponseFormat setType(ChatCompletionResponseFormatType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the chatCompletionSchemaProperties property: An open dictionary for extended properties. Required if 'type'
     * == 'json_schema'.
     * 
     * @return the chatCompletionSchemaProperties value.
     */
    @Generated
    public ChatCompletionResponseFormatJsonSchemaProperties getChatCompletionSchemaProperties() {
        return this.chatCompletionSchemaProperties;
    }

    /**
     * Set the chatCompletionSchemaProperties property: An open dictionary for extended properties. Required if 'type'
     * == 'json_schema'.
     * 
     * @param chatCompletionSchemaProperties the chatCompletionSchemaProperties value to set.
     * @return the ChatCompletionResponseFormat object itself.
     */
    @Generated
    public ChatCompletionResponseFormat setChatCompletionSchemaProperties(
        ChatCompletionResponseFormatJsonSchemaProperties chatCompletionSchemaProperties) {
        this.chatCompletionSchemaProperties = chatCompletionSchemaProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("jsonSchemaProperties", this.chatCompletionSchemaProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionResponseFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionResponseFormat if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatCompletionResponseFormat.
     */
    @Generated
    public static ChatCompletionResponseFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionResponseFormat deserializedChatCompletionResponseFormat = new ChatCompletionResponseFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedChatCompletionResponseFormat.type
                        = ChatCompletionResponseFormatType.fromString(reader.getString());
                } else if ("jsonSchemaProperties".equals(fieldName)) {
                    deserializedChatCompletionResponseFormat.chatCompletionSchemaProperties
                        = ChatCompletionResponseFormatJsonSchemaProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedChatCompletionResponseFormat;
        });
    }
}
