// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An open dictionary for extended properties. Required if 'type' == 'json_schema'.
 */
@Fluent
public final class ChatCompletionResponseFormatJsonSchemaProperties
    implements JsonSerializable<ChatCompletionResponseFormatJsonSchemaProperties> {
    /*
     * Name of the json schema the model will adhere to
     */
    @Generated
    private String name;

    /*
     * Description of the json schema the model will adhere to.
     */
    @Generated
    private String description;

    /*
     * Whether or not the model's response should use structured outputs. Default is true
     */
    @Generated
    private Boolean strict;

    /*
     * Object defining the custom schema the model will use to structure its output.
     */
    @Generated
    private ChatCompletionSchema schema;

    /**
     * Creates an instance of ChatCompletionResponseFormatJsonSchemaProperties class.
     */
    @Generated
    public ChatCompletionResponseFormatJsonSchemaProperties() {
    }

    /**
     * Get the name property: Name of the json schema the model will adhere to.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: Name of the json schema the model will adhere to.
     * 
     * @param name the name value to set.
     * @return the ChatCompletionResponseFormatJsonSchemaProperties object itself.
     */
    @Generated
    public ChatCompletionResponseFormatJsonSchemaProperties setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: Description of the json schema the model will adhere to.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Description of the json schema the model will adhere to.
     * 
     * @param description the description value to set.
     * @return the ChatCompletionResponseFormatJsonSchemaProperties object itself.
     */
    @Generated
    public ChatCompletionResponseFormatJsonSchemaProperties setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the strict property: Whether or not the model's response should use structured outputs. Default is true.
     * 
     * @return the strict value.
     */
    @Generated
    public Boolean isStrict() {
        return this.strict;
    }

    /**
     * Set the strict property: Whether or not the model's response should use structured outputs. Default is true.
     * 
     * @param strict the strict value to set.
     * @return the ChatCompletionResponseFormatJsonSchemaProperties object itself.
     */
    @Generated
    public ChatCompletionResponseFormatJsonSchemaProperties setStrict(Boolean strict) {
        this.strict = strict;
        return this;
    }

    /**
     * Get the schema property: Object defining the custom schema the model will use to structure its output.
     * 
     * @return the schema value.
     */
    @Generated
    public ChatCompletionSchema getSchema() {
        return this.schema;
    }

    /**
     * Set the schema property: Object defining the custom schema the model will use to structure its output.
     * 
     * @param schema the schema value to set.
     * @return the ChatCompletionResponseFormatJsonSchemaProperties object itself.
     */
    @Generated
    public ChatCompletionResponseFormatJsonSchemaProperties setSchema(ChatCompletionSchema schema) {
        this.schema = schema;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("strict", this.strict);
        jsonWriter.writeJsonField("schema", this.schema);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionResponseFormatJsonSchemaProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionResponseFormatJsonSchemaProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatCompletionResponseFormatJsonSchemaProperties.
     */
    @Generated
    public static ChatCompletionResponseFormatJsonSchemaProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionResponseFormatJsonSchemaProperties deserializedChatCompletionResponseFormatJsonSchemaProperties
                = new ChatCompletionResponseFormatJsonSchemaProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedChatCompletionResponseFormatJsonSchemaProperties.name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedChatCompletionResponseFormatJsonSchemaProperties.description = reader.getString();
                } else if ("strict".equals(fieldName)) {
                    deserializedChatCompletionResponseFormatJsonSchemaProperties.strict
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("schema".equals(fieldName)) {
                    deserializedChatCompletionResponseFormatJsonSchemaProperties.schema
                        = ChatCompletionSchema.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedChatCompletionResponseFormatJsonSchemaProperties;
        });
    }
}
