// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Object defining the custom schema the model will use to structure its output.
 */
@Fluent
public final class ChatCompletionSchema implements JsonSerializable<ChatCompletionSchema> {
    /*
     * Type of schema representation. Usually 'object'. Default is 'object'.
     */
    @Generated
    private String type;

    /*
     * A JSON-formatted string that defines the output schema's properties and constraints for the model.
     */
    @Generated
    private String properties;

    /*
     * An array of the property names that are required to be part of the model's response. All properties must be
     * included for structured outputs.
     */
    @Generated
    private List<String> required;

    /*
     * Controls whether it is allowable for an object to contain additional keys / values that were not defined in the
     * JSON Schema. Default is false.
     */
    @Generated
    private Boolean additionalProperties;

    /**
     * Creates an instance of ChatCompletionSchema class.
     */
    @Generated
    public ChatCompletionSchema() {
    }

    /**
     * Get the type property: Type of schema representation. Usually 'object'. Default is 'object'.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: Type of schema representation. Usually 'object'. Default is 'object'.
     * 
     * @param type the type value to set.
     * @return the ChatCompletionSchema object itself.
     */
    @Generated
    public ChatCompletionSchema setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the properties property: A JSON-formatted string that defines the output schema's properties and constraints
     * for the model.
     * 
     * @return the properties value.
     */
    @Generated
    public String getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: A JSON-formatted string that defines the output schema's properties and constraints
     * for the model.
     * 
     * @param properties the properties value to set.
     * @return the ChatCompletionSchema object itself.
     */
    @Generated
    public ChatCompletionSchema setProperties(String properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the required property: An array of the property names that are required to be part of the model's response.
     * All properties must be included for structured outputs.
     * 
     * @return the required value.
     */
    @Generated
    public List<String> getRequired() {
        return this.required;
    }

    /**
     * Set the required property: An array of the property names that are required to be part of the model's response.
     * All properties must be included for structured outputs.
     * 
     * @param required the required value to set.
     * @return the ChatCompletionSchema object itself.
     */
    @Generated
    public ChatCompletionSchema setRequired(List<String> required) {
        this.required = required;
        return this;
    }

    /**
     * Get the additionalProperties property: Controls whether it is allowable for an object to contain additional keys
     * / values that were not defined in the JSON Schema. Default is false.
     * 
     * @return the additionalProperties value.
     */
    @Generated
    public Boolean isAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Controls whether it is allowable for an object to contain additional keys
     * / values that were not defined in the JSON Schema. Default is false.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the ChatCompletionSchema object itself.
     */
    @Generated
    public ChatCompletionSchema setAdditionalProperties(Boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("properties", this.properties);
        jsonWriter.writeArrayField("required", this.required, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("additionalProperties", this.additionalProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChatCompletionSchema from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChatCompletionSchema if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChatCompletionSchema.
     */
    @Generated
    public static ChatCompletionSchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChatCompletionSchema deserializedChatCompletionSchema = new ChatCompletionSchema();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedChatCompletionSchema.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedChatCompletionSchema.properties = reader.getString();
                } else if ("required".equals(fieldName)) {
                    List<String> required = reader.readArray(reader1 -> reader1.getString());
                    deserializedChatCompletionSchema.required = required;
                } else if ("additionalProperties".equals(fieldName)) {
                    deserializedChatCompletionSchema.additionalProperties = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedChatCompletionSchema;
        });
    }
}
