// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

/**
 * Scripts that can be ignored by CjkBigramTokenFilter.
 */
public enum CjkBigramTokenFilterScripts {
    /**
     * Ignore Han script when forming bigrams of CJK terms.
     */
    HAN("han"),

    /**
     * Ignore Hiragana script when forming bigrams of CJK terms.
     */
    HIRAGANA("hiragana"),

    /**
     * Ignore Katakana script when forming bigrams of CJK terms.
     */
    KATAKANA("katakana"),

    /**
     * Ignore Hangul script when forming bigrams of CJK terms.
     */
    HANGUL("hangul");

    /**
     * The actual serialized value for a CjkBigramTokenFilterScripts instance.
     */
    private final String value;

    CjkBigramTokenFilterScripts(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CjkBigramTokenFilterScripts instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CjkBigramTokenFilterScripts object, or null if unable to parse.
     */
    public static CjkBigramTokenFilterScripts fromString(String value) {
        if (value == null) {
            return null;
        }
        CjkBigramTokenFilterScripts[] items = CjkBigramTokenFilterScripts.values();
        for (CjkBigramTokenFilterScripts item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
