// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Base type for describing any Azure AI service resource attached to a skillset.
 */
@Fluent
public class CognitiveServicesAccount implements JsonSerializable<CognitiveServicesAccount> {
    /*
     * A URI fragment specifying the type of Azure AI service resource attached to a skillset.
     */
    @Generated
    private String odataType = "CognitiveServicesAccount";

    /*
     * Description of the Azure AI service resource attached to a skillset.
     */
    @Generated
    private String description;

    /**
     * Creates an instance of CognitiveServicesAccount class.
     */
    @Generated
    public CognitiveServicesAccount() {
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of Azure AI service resource attached to a
     * skillset.
     * 
     * @return the odataType value.
     */
    @Generated
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the description property: Description of the Azure AI service resource attached to a skillset.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Description of the Azure AI service resource attached to a skillset.
     * 
     * @param description the description value to set.
     * @return the CognitiveServicesAccount object itself.
     */
    @Generated
    public CognitiveServicesAccount setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CognitiveServicesAccount from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CognitiveServicesAccount if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CognitiveServicesAccount.
     */
    @Generated
    public static CognitiveServicesAccount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("#Microsoft.Azure.Search.DefaultCognitiveServices".equals(discriminatorValue)) {
                    return DefaultCognitiveServicesAccount.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.CognitiveServicesByKey".equals(discriminatorValue)) {
                    return CognitiveServicesAccountKey.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.AIServicesByKey".equals(discriminatorValue)) {
                    return AIServicesAccountKey.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.AIServicesByIdentity".equals(discriminatorValue)) {
                    return AIServicesAccountIdentity.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static CognitiveServicesAccount fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CognitiveServicesAccount deserializedCognitiveServicesAccount = new CognitiveServicesAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("@odata.type".equals(fieldName)) {
                    deserializedCognitiveServicesAccount.odataType = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedCognitiveServicesAccount.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCognitiveServicesAccount;
        });
    }
}
