// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A skill that leverages Azure AI Content Understanding to process and extract structured insights from documents,
 * enabling enriched, searchable content for enhanced document indexing and retrieval.
 */
@Fluent
public final class ContentUnderstandingSkill extends SearchIndexerSkill {
    /*
     * A URI fragment specifying the type of skill.
     */
    @Generated
    private String odataType = "#Microsoft.Skills.Util.ContentUnderstandingSkill";

    /*
     * Controls the cardinality of the content extracted from the document by the skill
     */
    @Generated
    private List<ContentUnderstandingSkillExtractionOptions> extractionOptions;

    /*
     * Controls the cardinality for chunking the content.
     */
    @Generated
    private ContentUnderstandingSkillChunkingProperties chunkingProperties;

    /**
     * Creates an instance of ContentUnderstandingSkill class.
     * 
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     */
    @Generated
    public ContentUnderstandingSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of skill.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the extractionOptions property: Controls the cardinality of the content extracted from the document by the
     * skill.
     * 
     * @return the extractionOptions value.
     */
    @Generated
    public List<ContentUnderstandingSkillExtractionOptions> getExtractionOptions() {
        return this.extractionOptions;
    }

    /**
     * Set the extractionOptions property: Controls the cardinality of the content extracted from the document by the
     * skill.
     * 
     * @param extractionOptions the extractionOptions value to set.
     * @return the ContentUnderstandingSkill object itself.
     */
    @Generated
    public ContentUnderstandingSkill
        setExtractionOptions(List<ContentUnderstandingSkillExtractionOptions> extractionOptions) {
        this.extractionOptions = extractionOptions;
        return this;
    }

    /**
     * Get the chunkingProperties property: Controls the cardinality for chunking the content.
     * 
     * @return the chunkingProperties value.
     */
    @Generated
    public ContentUnderstandingSkillChunkingProperties getChunkingProperties() {
        return this.chunkingProperties;
    }

    /**
     * Set the chunkingProperties property: Controls the cardinality for chunking the content.
     * 
     * @param chunkingProperties the chunkingProperties value to set.
     * @return the ContentUnderstandingSkill object itself.
     */
    @Generated
    public ContentUnderstandingSkill
        setChunkingProperties(ContentUnderstandingSkillChunkingProperties chunkingProperties) {
        this.chunkingProperties = chunkingProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ContentUnderstandingSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ContentUnderstandingSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ContentUnderstandingSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeArrayField("extractionOptions", this.extractionOptions,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("chunkingProperties", this.chunkingProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentUnderstandingSkill from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentUnderstandingSkill if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContentUnderstandingSkill.
     */
    @Generated
    public static ContentUnderstandingSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List<InputFieldMappingEntry> inputs = null;
            boolean outputsFound = false;
            List<OutputFieldMappingEntry> outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Util.ContentUnderstandingSkill";
            List<ContentUnderstandingSkillExtractionOptions> extractionOptions = null;
            ContentUnderstandingSkillChunkingProperties chunkingProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                } else if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("context".equals(fieldName)) {
                    context = reader.getString();
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("extractionOptions".equals(fieldName)) {
                    extractionOptions = reader.readArray(
                        reader1 -> ContentUnderstandingSkillExtractionOptions.fromString(reader1.getString()));
                } else if ("chunkingProperties".equals(fieldName)) {
                    chunkingProperties = ContentUnderstandingSkillChunkingProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (inputsFound && outputsFound) {
                ContentUnderstandingSkill deserializedContentUnderstandingSkill
                    = new ContentUnderstandingSkill(inputs, outputs);
                deserializedContentUnderstandingSkill.setName(name);
                deserializedContentUnderstandingSkill.setDescription(description);
                deserializedContentUnderstandingSkill.setContext(context);
                deserializedContentUnderstandingSkill.odataType = odataType;
                deserializedContentUnderstandingSkill.extractionOptions = extractionOptions;
                deserializedContentUnderstandingSkill.chunkingProperties = chunkingProperties;

                return deserializedContentUnderstandingSkill;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
