// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Controls the cardinality of the content extracted from the document by the skill.
 */
public final class ContentUnderstandingSkillExtractionOptions
    extends ExpandableStringEnum<ContentUnderstandingSkillExtractionOptions> {
    /**
     * Specify that image content should be extracted from the document.
     */
    @Generated
    public static final ContentUnderstandingSkillExtractionOptions IMAGES = fromString("images");

    /**
     * Specify that location metadata should be extracted from the document.
     */
    @Generated
    public static final ContentUnderstandingSkillExtractionOptions LOCATION_METADATA = fromString("locationMetadata");

    /**
     * Creates a new instance of ContentUnderstandingSkillExtractionOptions value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ContentUnderstandingSkillExtractionOptions() {
    }

    /**
     * Creates or finds a ContentUnderstandingSkillExtractionOptions from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ContentUnderstandingSkillExtractionOptions.
     */
    @Generated
    public static ContentUnderstandingSkillExtractionOptions fromString(String name) {
        return fromString(name, ContentUnderstandingSkillExtractionOptions.class);
    }

    /**
     * Gets known ContentUnderstandingSkillExtractionOptions values.
     * 
     * @return known ContentUnderstandingSkillExtractionOptions values.
     */
    @Generated
    public static Collection<ContentUnderstandingSkillExtractionOptions> values() {
        return values(ContentUnderstandingSkillExtractionOptions.class);
    }
}
