// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Allows you to configure normalization for filterable, sortable, and facetable fields, which by default operate with
 * strict matching. This is a user-defined configuration consisting of at least one or more filters, which modify the
 * token that is stored.
 */
@Fluent
public final class CustomNormalizer extends LexicalNormalizer {
    /*
     * A URI fragment specifying the type of normalizer.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.CustomNormalizer";

    /*
     * A list of token filters used to filter out or modify the input token. For example, you can specify a lowercase
     * filter that converts all characters to lowercase. The filters are run in the order in which they are listed.
     */
    @Generated
    private List<TokenFilterName> tokenFilters;

    /*
     * A list of character filters used to prepare input text before it is processed. For instance, they can replace
     * certain characters or symbols. The filters are run in the order in which they are listed.
     */
    @Generated
    private List<CharFilterName> charFilters;

    /**
     * Creates an instance of CustomNormalizer class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public CustomNormalizer(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of normalizer.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the tokenFilters property: A list of token filters used to filter out or modify the input token. For example,
     * you can specify a lowercase filter that converts all characters to lowercase. The filters are run in the order in
     * which they are listed.
     * 
     * @return the tokenFilters value.
     */
    @Generated
    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    /**
     * Set the tokenFilters property: A list of token filters used to filter out or modify the input token. For example,
     * you can specify a lowercase filter that converts all characters to lowercase. The filters are run in the order in
     * which they are listed.
     * 
     * @param tokenFilters the tokenFilters value to set.
     * @return the CustomNormalizer object itself.
     */
    @Generated
    public CustomNormalizer setTokenFilters(List<TokenFilterName> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    /**
     * Get the charFilters property: A list of character filters used to prepare input text before it is processed. For
     * instance, they can replace certain characters or symbols. The filters are run in the order in which they are
     * listed.
     * 
     * @return the charFilters value.
     */
    @Generated
    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    /**
     * Set the charFilters property: A list of character filters used to prepare input text before it is processed. For
     * instance, they can replace certain characters or symbols. The filters are run in the order in which they are
     * listed.
     * 
     * @param charFilters the charFilters value to set.
     * @return the CustomNormalizer object itself.
     */
    @Generated
    public CustomNormalizer setCharFilters(List<CharFilterName> charFilters) {
        this.charFilters = charFilters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeArrayField("tokenFilters", this.tokenFilters,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("charFilters", this.charFilters,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomNormalizer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomNormalizer if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomNormalizer.
     */
    @Generated
    public static CustomNormalizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.CustomNormalizer";
            List<TokenFilterName> tokenFilters = null;
            List<CharFilterName> charFilters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("tokenFilters".equals(fieldName)) {
                    tokenFilters = reader.readArray(reader1 -> TokenFilterName.fromString(reader1.getString()));
                } else if ("charFilters".equals(fieldName)) {
                    charFilters = reader.readArray(reader1 -> CharFilterName.fromString(reader1.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                CustomNormalizer deserializedCustomNormalizer = new CustomNormalizer(name);
                deserializedCustomNormalizer.odataType = odataType;
                deserializedCustomNormalizer.tokenFilters = tokenFilters;
                deserializedCustomNormalizer.charFilters = charFilters;

                return deserializedCustomNormalizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
