// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * A skill that extracts content from a file within the enrichment pipeline.
 */
@Fluent
public final class DocumentExtractionSkill extends SearchIndexerSkill {
    /*
     * A URI fragment specifying the type of skill.
     */
    @Generated
    private String odataType = "#Microsoft.Skills.Util.DocumentExtractionSkill";

    /*
     * The parsingMode for the skill. Will be set to 'default' if not defined.
     */
    @Generated
    private String parsingMode;

    /*
     * The type of data to be extracted for the skill. Will be set to 'contentAndMetadata' if not defined.
     */
    @Generated
    private String dataToExtract;

    /*
     * A dictionary of configurations for the skill.
     */
    @Generated
    private Map<String, Object> configuration;

    /**
     * Creates an instance of DocumentExtractionSkill class.
     * 
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     */
    @Generated
    public DocumentExtractionSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs) {
        super(inputs, outputs);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of skill.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the parsingMode property: The parsingMode for the skill. Will be set to 'default' if not defined.
     * 
     * @return the parsingMode value.
     */
    @Generated
    public String getParsingMode() {
        return this.parsingMode;
    }

    /**
     * Set the parsingMode property: The parsingMode for the skill. Will be set to 'default' if not defined.
     * 
     * @param parsingMode the parsingMode value to set.
     * @return the DocumentExtractionSkill object itself.
     */
    @Generated
    public DocumentExtractionSkill setParsingMode(String parsingMode) {
        this.parsingMode = parsingMode;
        return this;
    }

    /**
     * Get the dataToExtract property: The type of data to be extracted for the skill. Will be set to
     * 'contentAndMetadata' if not defined.
     * 
     * @return the dataToExtract value.
     */
    @Generated
    public String getDataToExtract() {
        return this.dataToExtract;
    }

    /**
     * Set the dataToExtract property: The type of data to be extracted for the skill. Will be set to
     * 'contentAndMetadata' if not defined.
     * 
     * @param dataToExtract the dataToExtract value to set.
     * @return the DocumentExtractionSkill object itself.
     */
    @Generated
    public DocumentExtractionSkill setDataToExtract(String dataToExtract) {
        this.dataToExtract = dataToExtract;
        return this;
    }

    /**
     * Get the configuration property: A dictionary of configurations for the skill.
     * 
     * @return the configuration value.
     */
    @Generated
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: A dictionary of configurations for the skill.
     * 
     * @param configuration the configuration value to set.
     * @return the DocumentExtractionSkill object itself.
     */
    @Generated
    public DocumentExtractionSkill setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public DocumentExtractionSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public DocumentExtractionSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public DocumentExtractionSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("parsingMode", this.parsingMode);
        jsonWriter.writeStringField("dataToExtract", this.dataToExtract);
        jsonWriter.writeMapField("configuration", this.configuration,
            (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentExtractionSkill from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentExtractionSkill if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentExtractionSkill.
     */
    @Generated
    public static DocumentExtractionSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List<InputFieldMappingEntry> inputs = null;
            boolean outputsFound = false;
            List<OutputFieldMappingEntry> outputs = null;
            String name = null;
            String description = null;
            String context = null;
            String odataType = "#Microsoft.Skills.Util.DocumentExtractionSkill";
            String parsingMode = null;
            String dataToExtract = null;
            Map<String, Object> configuration = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                } else if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("context".equals(fieldName)) {
                    context = reader.getString();
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("parsingMode".equals(fieldName)) {
                    parsingMode = reader.getString();
                } else if ("dataToExtract".equals(fieldName)) {
                    dataToExtract = reader.getString();
                } else if ("configuration".equals(fieldName)) {
                    configuration = reader.readMap(reader1 -> reader1.readUntyped());
                } else {
                    reader.skipChildren();
                }
            }
            if (inputsFound && outputsFound) {
                DocumentExtractionSkill deserializedDocumentExtractionSkill
                    = new DocumentExtractionSkill(inputs, outputs);
                deserializedDocumentExtractionSkill.setName(name);
                deserializedDocumentExtractionSkill.setDescription(description);
                deserializedDocumentExtractionSkill.setContext(context);
                deserializedDocumentExtractionSkill.odataType = odataType;
                deserializedDocumentExtractionSkill.parsingMode = parsingMode;
                deserializedDocumentExtractionSkill.dataToExtract = dataToExtract;
                deserializedDocumentExtractionSkill.configuration = configuration;

                return deserializedDocumentExtractionSkill;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
