// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Controls the cardinality of the content extracted from the document by the skill.
 */
public final class DocumentIntelligenceLayoutSkillExtractionOptions
    extends ExpandableStringEnum<DocumentIntelligenceLayoutSkillExtractionOptions> {
    /**
     * Specify that image content should be extracted from the document.
     */
    @Generated
    public static final DocumentIntelligenceLayoutSkillExtractionOptions IMAGES = fromString("images");

    /**
     * Specify that location metadata should be extracted from the document.
     */
    @Generated
    public static final DocumentIntelligenceLayoutSkillExtractionOptions LOCATION_METADATA
        = fromString("locationMetadata");

    /**
     * Creates a new instance of DocumentIntelligenceLayoutSkillExtractionOptions value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public DocumentIntelligenceLayoutSkillExtractionOptions() {
    }

    /**
     * Creates or finds a DocumentIntelligenceLayoutSkillExtractionOptions from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DocumentIntelligenceLayoutSkillExtractionOptions.
     */
    @Generated
    public static DocumentIntelligenceLayoutSkillExtractionOptions fromString(String name) {
        return fromString(name, DocumentIntelligenceLayoutSkillExtractionOptions.class);
    }

    /**
     * Gets known DocumentIntelligenceLayoutSkillExtractionOptions values.
     * 
     * @return known DocumentIntelligenceLayoutSkillExtractionOptions values.
     */
    @Generated
    public static Collection<DocumentIntelligenceLayoutSkillExtractionOptions> values() {
        return values(DocumentIntelligenceLayoutSkillExtractionOptions.class);
    }
}
