// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Represents a function that transforms a value from a data source before indexing.
 */
@Fluent
public final class FieldMappingFunction implements JsonSerializable<FieldMappingFunction> {
    /*
     * The name of the field mapping function.
     */
    @Generated
    private final String name;

    /*
     * A dictionary of parameter name/value pairs to pass to the function. Each value must be of a primitive type.
     */
    @Generated
    private Map<String, Object> parameters;

    /**
     * Creates an instance of FieldMappingFunction class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public FieldMappingFunction(String name) {
        this.name = name;
    }

    /**
     * Get the name property: The name of the field mapping function.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the parameters property: A dictionary of parameter name/value pairs to pass to the function. Each value must
     * be of a primitive type.
     * 
     * @return the parameters value.
     */
    @Generated
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: A dictionary of parameter name/value pairs to pass to the function. Each value must
     * be of a primitive type.
     * 
     * @param parameters the parameters value to set.
     * @return the FieldMappingFunction object itself.
     */
    @Generated
    public FieldMappingFunction setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FieldMappingFunction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FieldMappingFunction if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FieldMappingFunction.
     */
    @Generated
    public static FieldMappingFunction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Map<String, Object> parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("parameters".equals(fieldName)) {
                    parameters = reader.readMap(reader1 -> reader1.readUntyped());
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                FieldMappingFunction deserializedFieldMappingFunction = new FieldMappingFunction(name);
                deserializedFieldMappingFunction.parameters = parameters;

                return deserializedFieldMappingFunction;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
