// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Configuration for OneLake knowledge source.
 */
@Fluent
public final class IndexedOneLakeKnowledgeSource extends KnowledgeSource {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.INDEXED_ONE_LAKE;

    /*
     * The parameters for the OneLake knowledge source.
     */
    @Generated
    private final IndexedOneLakeKnowledgeSourceParameters indexedOneLakeParameters;

    /**
     * Creates an instance of IndexedOneLakeKnowledgeSource class.
     * 
     * @param name the name value to set.
     * @param indexedOneLakeParameters the indexedOneLakeParameters value to set.
     */
    @Generated
    public IndexedOneLakeKnowledgeSource(String name,
        IndexedOneLakeKnowledgeSourceParameters indexedOneLakeParameters) {
        super(name);
        this.indexedOneLakeParameters = indexedOneLakeParameters;
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the indexedOneLakeParameters property: The parameters for the OneLake knowledge source.
     * 
     * @return the indexedOneLakeParameters value.
     */
    @Generated
    public IndexedOneLakeKnowledgeSourceParameters getIndexedOneLakeParameters() {
        return this.indexedOneLakeParameters;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IndexedOneLakeKnowledgeSource setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IndexedOneLakeKnowledgeSource setETag(String eTag) {
        super.setETag(eTag);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IndexedOneLakeKnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        super.setEncryptionKey(encryptionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("@odata.etag", getETag());
        jsonWriter.writeJsonField("encryptionKey", getEncryptionKey());
        jsonWriter.writeJsonField("indexedOneLakeParameters", this.indexedOneLakeParameters);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IndexedOneLakeKnowledgeSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IndexedOneLakeKnowledgeSource if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IndexedOneLakeKnowledgeSource.
     */
    @Generated
    public static IndexedOneLakeKnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            boolean indexedOneLakeParametersFound = false;
            IndexedOneLakeKnowledgeSourceParameters indexedOneLakeParameters = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.INDEXED_ONE_LAKE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                } else if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                } else if ("indexedOneLakeParameters".equals(fieldName)) {
                    indexedOneLakeParameters = IndexedOneLakeKnowledgeSourceParameters.fromJson(reader);
                    indexedOneLakeParametersFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && indexedOneLakeParametersFound) {
                IndexedOneLakeKnowledgeSource deserializedIndexedOneLakeKnowledgeSource
                    = new IndexedOneLakeKnowledgeSource(name, indexedOneLakeParameters);
                deserializedIndexedOneLakeKnowledgeSource.setDescription(description);
                deserializedIndexedOneLakeKnowledgeSource.setETag(eTag);
                deserializedIndexedOneLakeKnowledgeSource.setEncryptionKey(encryptionKey);
                deserializedIndexedOneLakeKnowledgeSource.kind = kind;

                return deserializedIndexedOneLakeKnowledgeSource;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!indexedOneLakeParametersFound) {
                missingProperties.add("indexedOneLakeParameters");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
