// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Parameters for OneLake knowledge source.
 */
@Fluent
public final class IndexedOneLakeKnowledgeSourceParameters
    implements JsonSerializable<IndexedOneLakeKnowledgeSourceParameters> {
    /*
     * OneLake workspace ID.
     */
    @Generated
    private final String fabricWorkspaceId;

    /*
     * Specifies which OneLake lakehouse to access.
     */
    @Generated
    private final String lakehouseId;

    /*
     * Optional OneLakehouse folder or shortcut to filter OneLake content.
     */
    @Generated
    private String targetPath;

    /*
     * Consolidates all general ingestion settings.
     */
    @Generated
    private KnowledgeSourceIngestionParameters ingestionParameters;

    /*
     * Resources created by the knowledge source.
     */
    @Generated
    private Map<String, String> createdResources;

    /**
     * Creates an instance of IndexedOneLakeKnowledgeSourceParameters class.
     * 
     * @param fabricWorkspaceId the fabricWorkspaceId value to set.
     * @param lakehouseId the lakehouseId value to set.
     */
    @Generated
    public IndexedOneLakeKnowledgeSourceParameters(String fabricWorkspaceId, String lakehouseId) {
        this.fabricWorkspaceId = fabricWorkspaceId;
        this.lakehouseId = lakehouseId;
    }

    /**
     * Get the fabricWorkspaceId property: OneLake workspace ID.
     * 
     * @return the fabricWorkspaceId value.
     */
    @Generated
    public String getFabricWorkspaceId() {
        return this.fabricWorkspaceId;
    }

    /**
     * Get the lakehouseId property: Specifies which OneLake lakehouse to access.
     * 
     * @return the lakehouseId value.
     */
    @Generated
    public String getLakehouseId() {
        return this.lakehouseId;
    }

    /**
     * Get the targetPath property: Optional OneLakehouse folder or shortcut to filter OneLake content.
     * 
     * @return the targetPath value.
     */
    @Generated
    public String getTargetPath() {
        return this.targetPath;
    }

    /**
     * Set the targetPath property: Optional OneLakehouse folder or shortcut to filter OneLake content.
     * 
     * @param targetPath the targetPath value to set.
     * @return the IndexedOneLakeKnowledgeSourceParameters object itself.
     */
    @Generated
    public IndexedOneLakeKnowledgeSourceParameters setTargetPath(String targetPath) {
        this.targetPath = targetPath;
        return this;
    }

    /**
     * Get the ingestionParameters property: Consolidates all general ingestion settings.
     * 
     * @return the ingestionParameters value.
     */
    @Generated
    public KnowledgeSourceIngestionParameters getIngestionParameters() {
        return this.ingestionParameters;
    }

    /**
     * Set the ingestionParameters property: Consolidates all general ingestion settings.
     * 
     * @param ingestionParameters the ingestionParameters value to set.
     * @return the IndexedOneLakeKnowledgeSourceParameters object itself.
     */
    @Generated
    public IndexedOneLakeKnowledgeSourceParameters
        setIngestionParameters(KnowledgeSourceIngestionParameters ingestionParameters) {
        this.ingestionParameters = ingestionParameters;
        return this;
    }

    /**
     * Get the createdResources property: Resources created by the knowledge source.
     * 
     * @return the createdResources value.
     */
    @Generated
    public Map<String, String> getCreatedResources() {
        return this.createdResources;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fabricWorkspaceId", this.fabricWorkspaceId);
        jsonWriter.writeStringField("lakehouseId", this.lakehouseId);
        jsonWriter.writeStringField("targetPath", this.targetPath);
        jsonWriter.writeJsonField("ingestionParameters", this.ingestionParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IndexedOneLakeKnowledgeSourceParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IndexedOneLakeKnowledgeSourceParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IndexedOneLakeKnowledgeSourceParameters.
     */
    @Generated
    public static IndexedOneLakeKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean fabricWorkspaceIdFound = false;
            String fabricWorkspaceId = null;
            boolean lakehouseIdFound = false;
            String lakehouseId = null;
            String targetPath = null;
            KnowledgeSourceIngestionParameters ingestionParameters = null;
            Map<String, String> createdResources = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("fabricWorkspaceId".equals(fieldName)) {
                    fabricWorkspaceId = reader.getString();
                    fabricWorkspaceIdFound = true;
                } else if ("lakehouseId".equals(fieldName)) {
                    lakehouseId = reader.getString();
                    lakehouseIdFound = true;
                } else if ("targetPath".equals(fieldName)) {
                    targetPath = reader.getString();
                } else if ("ingestionParameters".equals(fieldName)) {
                    ingestionParameters = KnowledgeSourceIngestionParameters.fromJson(reader);
                } else if ("createdResources".equals(fieldName)) {
                    createdResources = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (fabricWorkspaceIdFound && lakehouseIdFound) {
                IndexedOneLakeKnowledgeSourceParameters deserializedIndexedOneLakeKnowledgeSourceParameters
                    = new IndexedOneLakeKnowledgeSourceParameters(fabricWorkspaceId, lakehouseId);
                deserializedIndexedOneLakeKnowledgeSourceParameters.targetPath = targetPath;
                deserializedIndexedOneLakeKnowledgeSourceParameters.ingestionParameters = ingestionParameters;
                deserializedIndexedOneLakeKnowledgeSourceParameters.createdResources = createdResources;

                return deserializedIndexedOneLakeKnowledgeSourceParameters;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!fabricWorkspaceIdFound) {
                missingProperties.add("fabricWorkspaceId");
            }
            if (!lakehouseIdFound) {
                missingProperties.add("lakehouseId");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
