// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies which SharePoint libraries to access.
 */
public final class IndexedSharePointContainerName extends ExpandableStringEnum<IndexedSharePointContainerName> {
    /**
     * Index content from the site's default document library.
     */
    @Generated
    public static final IndexedSharePointContainerName DEFAULT_SITE_LIBRARY = fromString("defaultSiteLibrary");

    /**
     * Index content from every document library in the site.
     */
    @Generated
    public static final IndexedSharePointContainerName ALL_SITE_LIBRARIES = fromString("allSiteLibraries");

    /**
     * Index only content that matches the query specified in the knowledge source.
     */
    @Generated
    public static final IndexedSharePointContainerName USE_QUERY = fromString("useQuery");

    /**
     * Creates a new instance of IndexedSharePointContainerName value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public IndexedSharePointContainerName() {
    }

    /**
     * Creates or finds a IndexedSharePointContainerName from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IndexedSharePointContainerName.
     */
    @Generated
    public static IndexedSharePointContainerName fromString(String name) {
        return fromString(name, IndexedSharePointContainerName.class);
    }

    /**
     * Gets known IndexedSharePointContainerName values.
     * 
     * @return known IndexedSharePointContainerName values.
     */
    @Generated
    public static Collection<IndexedSharePointContainerName> values() {
        return values(IndexedSharePointContainerName.class);
    }
}
