// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Configuration for SharePoint knowledge source.
 */
@Fluent
public final class IndexedSharePointKnowledgeSource extends KnowledgeSource {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.INDEXED_SHARE_POINT;

    /*
     * The parameters for the SharePoint knowledge source.
     */
    @Generated
    private final IndexedSharePointKnowledgeSourceParameters indexedSharePointParameters;

    /**
     * Creates an instance of IndexedSharePointKnowledgeSource class.
     * 
     * @param name the name value to set.
     * @param indexedSharePointParameters the indexedSharePointParameters value to set.
     */
    @Generated
    public IndexedSharePointKnowledgeSource(String name,
        IndexedSharePointKnowledgeSourceParameters indexedSharePointParameters) {
        super(name);
        this.indexedSharePointParameters = indexedSharePointParameters;
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the indexedSharePointParameters property: The parameters for the SharePoint knowledge source.
     * 
     * @return the indexedSharePointParameters value.
     */
    @Generated
    public IndexedSharePointKnowledgeSourceParameters getIndexedSharePointParameters() {
        return this.indexedSharePointParameters;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IndexedSharePointKnowledgeSource setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IndexedSharePointKnowledgeSource setETag(String eTag) {
        super.setETag(eTag);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IndexedSharePointKnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        super.setEncryptionKey(encryptionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("@odata.etag", getETag());
        jsonWriter.writeJsonField("encryptionKey", getEncryptionKey());
        jsonWriter.writeJsonField("indexedSharePointParameters", this.indexedSharePointParameters);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IndexedSharePointKnowledgeSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IndexedSharePointKnowledgeSource if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IndexedSharePointKnowledgeSource.
     */
    @Generated
    public static IndexedSharePointKnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            boolean indexedSharePointParametersFound = false;
            IndexedSharePointKnowledgeSourceParameters indexedSharePointParameters = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.INDEXED_SHARE_POINT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                } else if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                } else if ("indexedSharePointParameters".equals(fieldName)) {
                    indexedSharePointParameters = IndexedSharePointKnowledgeSourceParameters.fromJson(reader);
                    indexedSharePointParametersFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && indexedSharePointParametersFound) {
                IndexedSharePointKnowledgeSource deserializedIndexedSharePointKnowledgeSource
                    = new IndexedSharePointKnowledgeSource(name, indexedSharePointParameters);
                deserializedIndexedSharePointKnowledgeSource.setDescription(description);
                deserializedIndexedSharePointKnowledgeSource.setETag(eTag);
                deserializedIndexedSharePointKnowledgeSource.setEncryptionKey(encryptionKey);
                deserializedIndexedSharePointKnowledgeSource.kind = kind;

                return deserializedIndexedSharePointKnowledgeSource;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!indexedSharePointParametersFound) {
                missingProperties.add("indexedSharePointParameters");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
