// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Parameters for SharePoint knowledge source.
 */
@Fluent
public final class IndexedSharePointKnowledgeSourceParameters
    implements JsonSerializable<IndexedSharePointKnowledgeSourceParameters> {
    /*
     * SharePoint connection string with format: SharePointOnlineEndpoint=[SharePoint site url];ApplicationId=[Azure AD
     * App ID];ApplicationSecret=[Azure AD App client secret];TenantId=[SharePoint site tenant id]
     */
    @Generated
    private final String connectionString;

    /*
     * Specifies which SharePoint libraries to access.
     */
    @Generated
    private final IndexedSharePointContainerName containerName;

    /*
     * Optional query to filter SharePoint content.
     */
    @Generated
    private String query;

    /*
     * Consolidates all general ingestion settings.
     */
    @Generated
    private KnowledgeSourceIngestionParameters ingestionParameters;

    /*
     * Resources created by the knowledge source.
     */
    @Generated
    private Map<String, String> createdResources;

    /**
     * Creates an instance of IndexedSharePointKnowledgeSourceParameters class.
     * 
     * @param connectionString the connectionString value to set.
     * @param containerName the containerName value to set.
     */
    @Generated
    public IndexedSharePointKnowledgeSourceParameters(String connectionString,
        IndexedSharePointContainerName containerName) {
        this.connectionString = connectionString;
        this.containerName = containerName;
    }

    /**
     * Get the connectionString property: SharePoint connection string with format: SharePointOnlineEndpoint=[SharePoint
     * site url];ApplicationId=[Azure AD App ID];ApplicationSecret=[Azure AD App client secret];TenantId=[SharePoint
     * site tenant id].
     * 
     * @return the connectionString value.
     */
    @Generated
    public String getConnectionString() {
        return this.connectionString;
    }

    /**
     * Get the containerName property: Specifies which SharePoint libraries to access.
     * 
     * @return the containerName value.
     */
    @Generated
    public IndexedSharePointContainerName getContainerName() {
        return this.containerName;
    }

    /**
     * Get the query property: Optional query to filter SharePoint content.
     * 
     * @return the query value.
     */
    @Generated
    public String getQuery() {
        return this.query;
    }

    /**
     * Set the query property: Optional query to filter SharePoint content.
     * 
     * @param query the query value to set.
     * @return the IndexedSharePointKnowledgeSourceParameters object itself.
     */
    @Generated
    public IndexedSharePointKnowledgeSourceParameters setQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Get the ingestionParameters property: Consolidates all general ingestion settings.
     * 
     * @return the ingestionParameters value.
     */
    @Generated
    public KnowledgeSourceIngestionParameters getIngestionParameters() {
        return this.ingestionParameters;
    }

    /**
     * Set the ingestionParameters property: Consolidates all general ingestion settings.
     * 
     * @param ingestionParameters the ingestionParameters value to set.
     * @return the IndexedSharePointKnowledgeSourceParameters object itself.
     */
    @Generated
    public IndexedSharePointKnowledgeSourceParameters
        setIngestionParameters(KnowledgeSourceIngestionParameters ingestionParameters) {
        this.ingestionParameters = ingestionParameters;
        return this;
    }

    /**
     * Get the createdResources property: Resources created by the knowledge source.
     * 
     * @return the createdResources value.
     */
    @Generated
    public Map<String, String> getCreatedResources() {
        return this.createdResources;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("containerName", this.containerName == null ? null : this.containerName.toString());
        jsonWriter.writeStringField("query", this.query);
        jsonWriter.writeJsonField("ingestionParameters", this.ingestionParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IndexedSharePointKnowledgeSourceParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IndexedSharePointKnowledgeSourceParameters if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IndexedSharePointKnowledgeSourceParameters.
     */
    @Generated
    public static IndexedSharePointKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean connectionStringFound = false;
            String connectionString = null;
            boolean containerNameFound = false;
            IndexedSharePointContainerName containerName = null;
            String query = null;
            KnowledgeSourceIngestionParameters ingestionParameters = null;
            Map<String, String> createdResources = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectionString".equals(fieldName)) {
                    connectionString = reader.getString();
                    connectionStringFound = true;
                } else if ("containerName".equals(fieldName)) {
                    containerName = IndexedSharePointContainerName.fromString(reader.getString());
                    containerNameFound = true;
                } else if ("query".equals(fieldName)) {
                    query = reader.getString();
                } else if ("ingestionParameters".equals(fieldName)) {
                    ingestionParameters = KnowledgeSourceIngestionParameters.fromJson(reader);
                } else if ("createdResources".equals(fieldName)) {
                    createdResources = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (connectionStringFound && containerNameFound) {
                IndexedSharePointKnowledgeSourceParameters deserializedIndexedSharePointKnowledgeSourceParameters
                    = new IndexedSharePointKnowledgeSourceParameters(connectionString, containerName);
                deserializedIndexedSharePointKnowledgeSourceParameters.query = query;
                deserializedIndexedSharePointKnowledgeSourceParameters.ingestionParameters = ingestionParameters;
                deserializedIndexedSharePointKnowledgeSourceParameters.createdResources = createdResources;

                return deserializedIndexedSharePointKnowledgeSourceParameters;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!connectionStringFound) {
                missingProperties.add("connectionString");
            }
            if (!containerNameFound) {
                missingProperties.add("containerName");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
