// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents all of the state that defines and dictates the indexer's current execution.
 */
@Immutable
public final class IndexerCurrentState implements JsonSerializable<IndexerCurrentState> {
    /*
     * The mode the indexer is running in.
     */
    @Generated
    private IndexingMode mode;

    /*
     * Change tracking state used when indexing starts on all documents in the datasource.
     */
    @Generated
    private String allDocsInitialTrackingState;

    /*
     * Change tracking state value when indexing finishes on all documents in the datasource.
     */
    @Generated
    private String allDocsFinalTrackingState;

    /*
     * Change tracking state used when indexing starts on select, reset documents in the datasource.
     */
    @Generated
    private String resetDocsInitialTrackingState;

    /*
     * Change tracking state value when indexing finishes on select, reset documents in the datasource.
     */
    @Generated
    private String resetDocsFinalTrackingState;

    /*
     * The list of document keys that have been reset. The document key is the document's unique identifier for the data
     * in the search index. The indexer will prioritize selectively re-ingesting these keys.
     */
    @Generated
    private List<String> resetDocumentKeys;

    /*
     * The list of datasource document ids that have been reset. The datasource document id is the unique identifier for
     * the data in the datasource. The indexer will prioritize selectively re-ingesting these ids.
     */
    @Generated
    private List<String> resetDatasourceDocumentIds;

    /*
     * Change tracking state used when indexing starts on selective options from the datasource.
     */
    @Generated
    private String resyncInitialTrackingState;

    /*
     * Change tracking state value when indexing finishes on selective options from the datasource.
     */
    @Generated
    private String resyncFinalTrackingState;

    /**
     * Creates an instance of IndexerCurrentState class.
     */
    @Generated
    public IndexerCurrentState() {
    }

    /**
     * Get the mode property: The mode the indexer is running in.
     * 
     * @return the mode value.
     */
    @Generated
    public IndexingMode getMode() {
        return this.mode;
    }

    /**
     * Get the allDocsInitialTrackingState property: Change tracking state used when indexing starts on all documents in
     * the datasource.
     * 
     * @return the allDocsInitialTrackingState value.
     */
    @Generated
    public String getAllDocsInitialTrackingState() {
        return this.allDocsInitialTrackingState;
    }

    /**
     * Get the allDocsFinalTrackingState property: Change tracking state value when indexing finishes on all documents
     * in the datasource.
     * 
     * @return the allDocsFinalTrackingState value.
     */
    @Generated
    public String getAllDocsFinalTrackingState() {
        return this.allDocsFinalTrackingState;
    }

    /**
     * Get the resetDocsInitialTrackingState property: Change tracking state used when indexing starts on select, reset
     * documents in the datasource.
     * 
     * @return the resetDocsInitialTrackingState value.
     */
    @Generated
    public String getResetDocsInitialTrackingState() {
        return this.resetDocsInitialTrackingState;
    }

    /**
     * Get the resetDocsFinalTrackingState property: Change tracking state value when indexing finishes on select, reset
     * documents in the datasource.
     * 
     * @return the resetDocsFinalTrackingState value.
     */
    @Generated
    public String getResetDocsFinalTrackingState() {
        return this.resetDocsFinalTrackingState;
    }

    /**
     * Get the resetDocumentKeys property: The list of document keys that have been reset. The document key is the
     * document's unique identifier for the data in the search index. The indexer will prioritize selectively
     * re-ingesting these keys.
     * 
     * @return the resetDocumentKeys value.
     */
    @Generated
    public List<String> getResetDocumentKeys() {
        return this.resetDocumentKeys;
    }

    /**
     * Get the resetDatasourceDocumentIds property: The list of datasource document ids that have been reset. The
     * datasource document id is the unique identifier for the data in the datasource. The indexer will prioritize
     * selectively re-ingesting these ids.
     * 
     * @return the resetDatasourceDocumentIds value.
     */
    @Generated
    public List<String> getResetDatasourceDocumentIds() {
        return this.resetDatasourceDocumentIds;
    }

    /**
     * Get the resyncInitialTrackingState property: Change tracking state used when indexing starts on selective options
     * from the datasource.
     * 
     * @return the resyncInitialTrackingState value.
     */
    @Generated
    public String getResyncInitialTrackingState() {
        return this.resyncInitialTrackingState;
    }

    /**
     * Get the resyncFinalTrackingState property: Change tracking state value when indexing finishes on selective
     * options from the datasource.
     * 
     * @return the resyncFinalTrackingState value.
     */
    @Generated
    public String getResyncFinalTrackingState() {
        return this.resyncFinalTrackingState;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IndexerCurrentState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IndexerCurrentState if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IndexerCurrentState.
     */
    @Generated
    public static IndexerCurrentState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IndexerCurrentState deserializedIndexerCurrentState = new IndexerCurrentState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("mode".equals(fieldName)) {
                    deserializedIndexerCurrentState.mode = IndexingMode.fromString(reader.getString());
                } else if ("allDocsInitialTrackingState".equals(fieldName)) {
                    deserializedIndexerCurrentState.allDocsInitialTrackingState = reader.getString();
                } else if ("allDocsFinalTrackingState".equals(fieldName)) {
                    deserializedIndexerCurrentState.allDocsFinalTrackingState = reader.getString();
                } else if ("resetDocsInitialTrackingState".equals(fieldName)) {
                    deserializedIndexerCurrentState.resetDocsInitialTrackingState = reader.getString();
                } else if ("resetDocsFinalTrackingState".equals(fieldName)) {
                    deserializedIndexerCurrentState.resetDocsFinalTrackingState = reader.getString();
                } else if ("resetDocumentKeys".equals(fieldName)) {
                    List<String> resetDocumentKeys = reader.readArray(reader1 -> reader1.getString());
                    deserializedIndexerCurrentState.resetDocumentKeys = resetDocumentKeys;
                } else if ("resetDatasourceDocumentIds".equals(fieldName)) {
                    List<String> resetDatasourceDocumentIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedIndexerCurrentState.resetDatasourceDocumentIds = resetDatasourceDocumentIds;
                } else if ("resyncInitialTrackingState".equals(fieldName)) {
                    deserializedIndexerCurrentState.resyncInitialTrackingState = reader.getString();
                } else if ("resyncFinalTrackingState".equals(fieldName)) {
                    deserializedIndexerCurrentState.resyncFinalTrackingState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIndexerCurrentState;
        });
    }
}
