// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Options with various types of permission data to index.
 */
public final class IndexerPermissionOption extends ExpandableStringEnum<IndexerPermissionOption> {
    /**
     * Indexer to ingest ACL userIds from data source to index.
     */
    @Generated
    public static final IndexerPermissionOption USER_IDS = fromString("userIds");

    /**
     * Indexer to ingest ACL groupIds from data source to index.
     */
    @Generated
    public static final IndexerPermissionOption GROUP_IDS = fromString("groupIds");

    /**
     * Indexer to ingest Azure RBAC scope from data source to index.
     */
    @Generated
    public static final IndexerPermissionOption RBAC_SCOPE = fromString("rbacScope");

    /**
     * Creates a new instance of IndexerPermissionOption value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public IndexerPermissionOption() {
    }

    /**
     * Creates or finds a IndexerPermissionOption from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IndexerPermissionOption.
     */
    @Generated
    public static IndexerPermissionOption fromString(String name) {
        return fromString(name, IndexerPermissionOption.class);
    }

    /**
     * Gets known IndexerPermissionOption values.
     * 
     * @return known IndexerPermissionOption values.
     */
    @Generated
    public static Collection<IndexerPermissionOption> values() {
        return values(IndexerPermissionOption.class);
    }
}
