// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The IndexerResyncBody model.
 */
@Fluent
public final class IndexerResyncBody implements JsonSerializable<IndexerResyncBody> {
    /*
     * Re-sync options that have been pre-defined from data source.
     */
    @Generated
    private List<IndexerResyncOption> options;

    /**
     * Creates an instance of IndexerResyncBody class.
     */
    @Generated
    public IndexerResyncBody() {
    }

    /**
     * Get the options property: Re-sync options that have been pre-defined from data source.
     * 
     * @return the options value.
     */
    @Generated
    public List<IndexerResyncOption> getOptions() {
        return this.options;
    }

    /**
     * Set the options property: Re-sync options that have been pre-defined from data source.
     * 
     * @param options the options value to set.
     * @return the IndexerResyncBody object itself.
     */
    @Generated
    public IndexerResyncBody setOptions(List<IndexerResyncOption> options) {
        this.options = options;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("options", this.options,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IndexerResyncBody from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IndexerResyncBody if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IndexerResyncBody.
     */
    @Generated
    public static IndexerResyncBody fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IndexerResyncBody deserializedIndexerResyncBody = new IndexerResyncBody();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("options".equals(fieldName)) {
                    List<IndexerResyncOption> options
                        = reader.readArray(reader1 -> IndexerResyncOption.fromString(reader1.getString()));
                    deserializedIndexerResyncBody.options = options;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIndexerResyncBody;
        });
    }
}
