// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Represents the mode the indexer is executing in.
 */
public final class IndexingMode extends ExpandableStringEnum<IndexingMode> {
    /**
     * The indexer is indexing all documents in the datasource.
     */
    @Generated
    public static final IndexingMode INDEXING_ALL_DOCS = fromString("indexingAllDocs");

    /**
     * The indexer is indexing selective, reset documents in the datasource. The documents being indexed are defined on
     * indexer status.
     */
    @Generated
    public static final IndexingMode INDEXING_RESET_DOCS = fromString("indexingResetDocs");

    /**
     * The indexer is resyncing and indexing selective option(s) from the datasource.
     */
    @Generated
    public static final IndexingMode INDEXING_RESYNC = fromString("indexingResync");

    /**
     * Creates a new instance of IndexingMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public IndexingMode() {
    }

    /**
     * Creates or finds a IndexingMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IndexingMode.
     */
    @Generated
    public static IndexingMode fromString(String name) {
        return fromString(name, IndexingMode.class);
    }

    /**
     * Gets known IndexingMode values.
     * 
     * @return known IndexingMode values.
     */
    @Generated
    public static Collection<IndexingMode> values() {
        return values(IndexingMode.class);
    }
}
