// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Marks terms as keywords. This token filter is implemented using Apache Lucene.
 */
@Fluent
public final class KeywordMarkerTokenFilter extends TokenFilter {
    /*
     * A URI fragment specifying the type of token filter.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.KeywordMarkerTokenFilter";

    /*
     * A list of words to mark as keywords.
     */
    @Generated
    private final List<String> keywords;

    /*
     * A value indicating whether to ignore case. If true, all words are converted to lower case first. Default is
     * false.
     */
    @Generated
    private Boolean caseIgnored;

    /**
     * Creates an instance of KeywordMarkerTokenFilter class.
     * 
     * @param name the name value to set.
     * @param keywords the keywords value to set.
     */
    @Generated
    public KeywordMarkerTokenFilter(String name, List<String> keywords) {
        super(name);
        this.keywords = keywords;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the keywords property: A list of words to mark as keywords.
     * 
     * @return the keywords value.
     */
    @Generated
    public List<String> getKeywords() {
        return this.keywords;
    }

    /**
     * Get the caseIgnored property: A value indicating whether to ignore case. If true, all words are converted to
     * lower case first. Default is false.
     * 
     * @return the caseIgnored value.
     */
    @Generated
    public Boolean isCaseIgnored() {
        return this.caseIgnored;
    }

    /**
     * Set the caseIgnored property: A value indicating whether to ignore case. If true, all words are converted to
     * lower case first. Default is false.
     * 
     * @param caseIgnored the caseIgnored value to set.
     * @return the KeywordMarkerTokenFilter object itself.
     */
    @Generated
    public KeywordMarkerTokenFilter setCaseIgnored(Boolean caseIgnored) {
        this.caseIgnored = caseIgnored;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeArrayField("keywords", this.keywords, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeBooleanField("ignoreCase", this.caseIgnored);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeywordMarkerTokenFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeywordMarkerTokenFilter if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeywordMarkerTokenFilter.
     */
    @Generated
    public static KeywordMarkerTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean keywordsFound = false;
            List<String> keywords = null;
            String odataType = "#Microsoft.Azure.Search.KeywordMarkerTokenFilter";
            Boolean caseIgnored = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("keywords".equals(fieldName)) {
                    keywords = reader.readArray(reader1 -> reader1.getString());
                    keywordsFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("ignoreCase".equals(fieldName)) {
                    caseIgnored = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && keywordsFound) {
                KeywordMarkerTokenFilter deserializedKeywordMarkerTokenFilter
                    = new KeywordMarkerTokenFilter(name, keywords);
                deserializedKeywordMarkerTokenFilter.odataType = odataType;
                deserializedKeywordMarkerTokenFilter.caseIgnored = caseIgnored;

                return deserializedKeywordMarkerTokenFilter;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!keywordsFound) {
                missingProperties.add("keywords");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
