// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * The KnowledgeBase model.
 */
@Fluent
public final class KnowledgeBase implements JsonSerializable<KnowledgeBase> {
    /*
     * The name of the knowledge knowledge base.
     */
    @Generated
    private final String name;

    /*
     * The knowledgeSources property.
     */
    @Generated
    private final List<KnowledgeSourceReference> knowledgeSources;

    /*
     * Contains configuration options on how to connect to AI models.
     */
    @Generated
    private List<KnowledgeBaseModel> models;

    /*
     * The retrievalReasoningEffort property.
     */
    @Generated
    private KnowledgeRetrievalReasoningEffort retrievalReasoningEffort;

    /*
     * The output configuration for this retrieval.
     */
    @Generated
    private KnowledgeRetrievalOutputMode outputMode;

    /*
     * The ETag of the knowledge base.
     */
    @Generated
    private String eTag;

    /*
     * A description of an encryption key that you create in Azure Key Vault. This key is used to provide an additional
     * level of encryption-at-rest for your knowledge base definition when you want full assurance that no one, not even
     * Microsoft, can decrypt them. Once you have encrypted your knowledge base definition, it will always remain
     * encrypted. The search service will ignore attempts to set this property to null. You can change this property as
     * needed if you want to rotate your encryption key; Your knowledge base definition will be unaffected. Encryption
     * with customer-managed keys is not available for free search services, and is only available for paid services
     * created on or after January 1, 2019.
     */
    @Generated
    private SearchResourceEncryptionKey encryptionKey;

    /*
     * The description of the knowledge base.
     */
    @Generated
    private String description;

    /*
     * Instructions considered by the knowledge knowledge base when developing query plan.
     */
    @Generated
    private String retrievalInstructions;

    /*
     * Instructions considered by the knowledge knowledge base when generating answers.
     */
    @Generated
    private String answerInstructions;

    /**
     * Creates an instance of KnowledgeBase class.
     * 
     * @param name the name value to set.
     * @param knowledgeSources the knowledgeSources value to set.
     */
    @Generated
    public KnowledgeBase(String name, List<KnowledgeSourceReference> knowledgeSources) {
        this.name = name;
        this.knowledgeSources = knowledgeSources;
    }

    /**
     * Get the name property: The name of the knowledge knowledge base.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the knowledgeSources property: The knowledgeSources property.
     * 
     * @return the knowledgeSources value.
     */
    @Generated
    public List<KnowledgeSourceReference> getKnowledgeSources() {
        return this.knowledgeSources;
    }

    /**
     * Get the models property: Contains configuration options on how to connect to AI models.
     * 
     * @return the models value.
     */
    @Generated
    public List<KnowledgeBaseModel> getModels() {
        return this.models;
    }

    /**
     * Set the models property: Contains configuration options on how to connect to AI models.
     * 
     * @param models the models value to set.
     * @return the KnowledgeBase object itself.
     */
    @Generated
    public KnowledgeBase setModels(List<KnowledgeBaseModel> models) {
        this.models = models;
        return this;
    }

    /**
     * Get the retrievalReasoningEffort property: The retrievalReasoningEffort property.
     * 
     * @return the retrievalReasoningEffort value.
     */
    @Generated
    public KnowledgeRetrievalReasoningEffort getRetrievalReasoningEffort() {
        return this.retrievalReasoningEffort;
    }

    /**
     * Set the retrievalReasoningEffort property: The retrievalReasoningEffort property.
     * 
     * @param retrievalReasoningEffort the retrievalReasoningEffort value to set.
     * @return the KnowledgeBase object itself.
     */
    @Generated
    public KnowledgeBase setRetrievalReasoningEffort(KnowledgeRetrievalReasoningEffort retrievalReasoningEffort) {
        this.retrievalReasoningEffort = retrievalReasoningEffort;
        return this;
    }

    /**
     * Get the outputMode property: The output configuration for this retrieval.
     * 
     * @return the outputMode value.
     */
    @Generated
    public KnowledgeRetrievalOutputMode getOutputMode() {
        return this.outputMode;
    }

    /**
     * Set the outputMode property: The output configuration for this retrieval.
     * 
     * @param outputMode the outputMode value to set.
     * @return the KnowledgeBase object itself.
     */
    @Generated
    public KnowledgeBase setOutputMode(KnowledgeRetrievalOutputMode outputMode) {
        this.outputMode = outputMode;
        return this;
    }

    /**
     * Get the eTag property: The ETag of the knowledge base.
     * 
     * @return the eTag value.
     */
    @Generated
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The ETag of the knowledge base.
     * 
     * @param eTag the eTag value to set.
     * @return the KnowledgeBase object itself.
     */
    @Generated
    public KnowledgeBase setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the encryptionKey property: A description of an encryption key that you create in Azure Key Vault. This key
     * is used to provide an additional level of encryption-at-rest for your knowledge base definition when you want
     * full assurance that no one, not even Microsoft, can decrypt them. Once you have encrypted your knowledge base
     * definition, it will always remain encrypted. The search service will ignore attempts to set this property to
     * null. You can change this property as needed if you want to rotate your encryption key; Your knowledge base
     * definition will be unaffected. Encryption with customer-managed keys is not available for free search services,
     * and is only available for paid services created on or after January 1, 2019.
     * 
     * @return the encryptionKey value.
     */
    @Generated
    public SearchResourceEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    /**
     * Set the encryptionKey property: A description of an encryption key that you create in Azure Key Vault. This key
     * is used to provide an additional level of encryption-at-rest for your knowledge base definition when you want
     * full assurance that no one, not even Microsoft, can decrypt them. Once you have encrypted your knowledge base
     * definition, it will always remain encrypted. The search service will ignore attempts to set this property to
     * null. You can change this property as needed if you want to rotate your encryption key; Your knowledge base
     * definition will be unaffected. Encryption with customer-managed keys is not available for free search services,
     * and is only available for paid services created on or after January 1, 2019.
     * 
     * @param encryptionKey the encryptionKey value to set.
     * @return the KnowledgeBase object itself.
     */
    @Generated
    public KnowledgeBase setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    /**
     * Get the description property: The description of the knowledge base.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: The description of the knowledge base.
     * 
     * @param description the description value to set.
     * @return the KnowledgeBase object itself.
     */
    @Generated
    public KnowledgeBase setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the retrievalInstructions property: Instructions considered by the knowledge knowledge base when developing
     * query plan.
     * 
     * @return the retrievalInstructions value.
     */
    @Generated
    public String getRetrievalInstructions() {
        return this.retrievalInstructions;
    }

    /**
     * Set the retrievalInstructions property: Instructions considered by the knowledge knowledge base when developing
     * query plan.
     * 
     * @param retrievalInstructions the retrievalInstructions value to set.
     * @return the KnowledgeBase object itself.
     */
    @Generated
    public KnowledgeBase setRetrievalInstructions(String retrievalInstructions) {
        this.retrievalInstructions = retrievalInstructions;
        return this;
    }

    /**
     * Get the answerInstructions property: Instructions considered by the knowledge knowledge base when generating
     * answers.
     * 
     * @return the answerInstructions value.
     */
    @Generated
    public String getAnswerInstructions() {
        return this.answerInstructions;
    }

    /**
     * Set the answerInstructions property: Instructions considered by the knowledge knowledge base when generating
     * answers.
     * 
     * @param answerInstructions the answerInstructions value to set.
     * @return the KnowledgeBase object itself.
     */
    @Generated
    public KnowledgeBase setAnswerInstructions(String answerInstructions) {
        this.answerInstructions = answerInstructions;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("knowledgeSources", this.knowledgeSources,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("models", this.models, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("retrievalReasoningEffort", this.retrievalReasoningEffort);
        jsonWriter.writeStringField("outputMode", this.outputMode == null ? null : this.outputMode.toString());
        jsonWriter.writeStringField("@odata.etag", this.eTag);
        jsonWriter.writeJsonField("encryptionKey", this.encryptionKey);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("retrievalInstructions", this.retrievalInstructions);
        jsonWriter.writeStringField("answerInstructions", this.answerInstructions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBase if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBase.
     */
    @Generated
    public static KnowledgeBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean knowledgeSourcesFound = false;
            List<KnowledgeSourceReference> knowledgeSources = null;
            List<KnowledgeBaseModel> models = null;
            KnowledgeRetrievalReasoningEffort retrievalReasoningEffort = null;
            KnowledgeRetrievalOutputMode outputMode = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            String description = null;
            String retrievalInstructions = null;
            String answerInstructions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("knowledgeSources".equals(fieldName)) {
                    knowledgeSources = reader.readArray(reader1 -> KnowledgeSourceReference.fromJson(reader1));
                    knowledgeSourcesFound = true;
                } else if ("models".equals(fieldName)) {
                    models = reader.readArray(reader1 -> KnowledgeBaseModel.fromJson(reader1));
                } else if ("retrievalReasoningEffort".equals(fieldName)) {
                    retrievalReasoningEffort = KnowledgeRetrievalReasoningEffort.fromJson(reader);
                } else if ("outputMode".equals(fieldName)) {
                    outputMode = KnowledgeRetrievalOutputMode.fromString(reader.getString());
                } else if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                } else if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("retrievalInstructions".equals(fieldName)) {
                    retrievalInstructions = reader.getString();
                } else if ("answerInstructions".equals(fieldName)) {
                    answerInstructions = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && knowledgeSourcesFound) {
                KnowledgeBase deserializedKnowledgeBase = new KnowledgeBase(name, knowledgeSources);
                deserializedKnowledgeBase.models = models;
                deserializedKnowledgeBase.retrievalReasoningEffort = retrievalReasoningEffort;
                deserializedKnowledgeBase.outputMode = outputMode;
                deserializedKnowledgeBase.eTag = eTag;
                deserializedKnowledgeBase.encryptionKey = encryptionKey;
                deserializedKnowledgeBase.description = description;
                deserializedKnowledgeBase.retrievalInstructions = retrievalInstructions;
                deserializedKnowledgeBase.answerInstructions = answerInstructions;

                return deserializedKnowledgeBase;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!knowledgeSourcesFound) {
                missingProperties.add("knowledgeSources");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
