// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the Azure OpenAI resource used to do query planning.
 */
@Immutable
public final class KnowledgeBaseAzureOpenAIModel extends KnowledgeBaseModel {
    /*
     * The type of AI model.
     */
    @Generated
    private KnowledgeBaseModelKind kind = KnowledgeBaseModelKind.AZURE_OPEN_AI;

    /*
     * Contains the parameters specific to Azure OpenAI model endpoint.
     */
    @Generated
    private final AzureOpenAIVectorizerParameters azureOpenAIParameters;

    /**
     * Creates an instance of KnowledgeBaseAzureOpenAIModel class.
     * 
     * @param azureOpenAIParameters the azureOpenAIParameters value to set.
     */
    @Generated
    public KnowledgeBaseAzureOpenAIModel(AzureOpenAIVectorizerParameters azureOpenAIParameters) {
        this.azureOpenAIParameters = azureOpenAIParameters;
    }

    /**
     * Get the kind property: The type of AI model.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeBaseModelKind getKind() {
        return this.kind;
    }

    /**
     * Get the azureOpenAIParameters property: Contains the parameters specific to Azure OpenAI model endpoint.
     * 
     * @return the azureOpenAIParameters value.
     */
    @Generated
    public AzureOpenAIVectorizerParameters getAzureOpenAIParameters() {
        return this.azureOpenAIParameters;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureOpenAIParameters", this.azureOpenAIParameters);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseAzureOpenAIModel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseAzureOpenAIModel if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseAzureOpenAIModel.
     */
    @Generated
    public static KnowledgeBaseAzureOpenAIModel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean azureOpenAIParametersFound = false;
            AzureOpenAIVectorizerParameters azureOpenAIParameters = null;
            KnowledgeBaseModelKind kind = KnowledgeBaseModelKind.AZURE_OPEN_AI;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("azureOpenAIParameters".equals(fieldName)) {
                    azureOpenAIParameters = AzureOpenAIVectorizerParameters.fromJson(reader);
                    azureOpenAIParametersFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeBaseModelKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (azureOpenAIParametersFound) {
                KnowledgeBaseAzureOpenAIModel deserializedKnowledgeBaseAzureOpenAIModel
                    = new KnowledgeBaseAzureOpenAIModel(azureOpenAIParameters);
                deserializedKnowledgeBaseAzureOpenAIModel.kind = kind;

                return deserializedKnowledgeBaseAzureOpenAIModel;
            }
            throw new IllegalStateException("Missing required property: azureOpenAIParameters");
        });
    }
}
