// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the connection parameters for the model to use for query planning.
 */
@Immutable
public class KnowledgeBaseModel implements JsonSerializable<KnowledgeBaseModel> {
    /*
     * The type of AI model.
     */
    @Generated
    private KnowledgeBaseModelKind kind = KnowledgeBaseModelKind.fromString("KnowledgeBaseModel");

    /**
     * Creates an instance of KnowledgeBaseModel class.
     */
    @Generated
    public KnowledgeBaseModel() {
    }

    /**
     * Get the kind property: The type of AI model.
     * 
     * @return the kind value.
     */
    @Generated
    public KnowledgeBaseModelKind getKind() {
        return this.kind;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseModel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseModel if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeBaseModel.
     */
    @Generated
    public static KnowledgeBaseModel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("azureOpenAI".equals(discriminatorValue)) {
                    return KnowledgeBaseAzureOpenAIModel.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeBaseModel fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeBaseModel deserializedKnowledgeBaseModel = new KnowledgeBaseModel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedKnowledgeBaseModel.kind = KnowledgeBaseModelKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeBaseModel;
        });
    }
}
