// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Run knowledge retrieval with minimal reasoning effort.
 */
@Immutable
public final class KnowledgeRetrievalMinimalReasoningEffort extends KnowledgeRetrievalReasoningEffort {
    /*
     * The kind of reasoning effort.
     */
    @Generated
    private KnowledgeRetrievalReasoningEffortKind kind = KnowledgeRetrievalReasoningEffortKind.MINIMAL;

    /**
     * Creates an instance of KnowledgeRetrievalMinimalReasoningEffort class.
     */
    @Generated
    public KnowledgeRetrievalMinimalReasoningEffort() {
    }

    /**
     * Get the kind property: The kind of reasoning effort.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeRetrievalReasoningEffortKind getKind() {
        return this.kind;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeRetrievalMinimalReasoningEffort from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeRetrievalMinimalReasoningEffort if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeRetrievalMinimalReasoningEffort.
     */
    @Generated
    public static KnowledgeRetrievalMinimalReasoningEffort fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeRetrievalMinimalReasoningEffort deserializedKnowledgeRetrievalMinimalReasoningEffort
                = new KnowledgeRetrievalMinimalReasoningEffort();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedKnowledgeRetrievalMinimalReasoningEffort.kind
                        = KnowledgeRetrievalReasoningEffortKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeRetrievalMinimalReasoningEffort;
        });
    }
}
