// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the Azure OpenAI resource used to vectorize a query string.
 */
@Fluent
public final class KnowledgeSourceAzureOpenAIVectorizer extends KnowledgeSourceVectorizer {
    /*
     * The name of the kind of vectorization method being configured for use with vector search.
     */
    @Generated
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.AZURE_OPEN_AI;

    /*
     * Contains the parameters specific to Azure OpenAI embedding vectorization.
     */
    @Generated
    private AzureOpenAIVectorizerParameters azureOpenAIParameters;

    /**
     * Creates an instance of KnowledgeSourceAzureOpenAIVectorizer class.
     */
    @Generated
    public KnowledgeSourceAzureOpenAIVectorizer() {
    }

    /**
     * Get the kind property: The name of the kind of vectorization method being configured for use with vector search.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    /**
     * Get the azureOpenAIParameters property: Contains the parameters specific to Azure OpenAI embedding vectorization.
     * 
     * @return the azureOpenAIParameters value.
     */
    @Generated
    public AzureOpenAIVectorizerParameters getAzureOpenAIParameters() {
        return this.azureOpenAIParameters;
    }

    /**
     * Set the azureOpenAIParameters property: Contains the parameters specific to Azure OpenAI embedding vectorization.
     * 
     * @param azureOpenAIParameters the azureOpenAIParameters value to set.
     * @return the KnowledgeSourceAzureOpenAIVectorizer object itself.
     */
    @Generated
    public KnowledgeSourceAzureOpenAIVectorizer
        setAzureOpenAIParameters(AzureOpenAIVectorizerParameters azureOpenAIParameters) {
        this.azureOpenAIParameters = azureOpenAIParameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("azureOpenAIParameters", this.azureOpenAIParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeSourceAzureOpenAIVectorizer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeSourceAzureOpenAIVectorizer if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeSourceAzureOpenAIVectorizer.
     */
    @Generated
    public static KnowledgeSourceAzureOpenAIVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeSourceAzureOpenAIVectorizer deserializedKnowledgeSourceAzureOpenAIVectorizer
                = new KnowledgeSourceAzureOpenAIVectorizer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedKnowledgeSourceAzureOpenAIVectorizer.kind
                        = VectorSearchVectorizerKind.fromString(reader.getString());
                } else if ("azureOpenAIParameters".equals(fieldName)) {
                    deserializedKnowledgeSourceAzureOpenAIVectorizer.azureOpenAIParameters
                        = AzureOpenAIVectorizerParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeSourceAzureOpenAIVectorizer;
        });
    }
}
