// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Optional content extraction mode. Default is 'minimal'.
 */
public final class KnowledgeSourceContentExtractionMode
    extends ExpandableStringEnum<KnowledgeSourceContentExtractionMode> {
    /**
     * Extracts only essential metadata while deferring most content processing.
     */
    @Generated
    public static final KnowledgeSourceContentExtractionMode MINIMAL = fromString("minimal");

    /**
     * Performs the full default content extraction pipeline.
     */
    @Generated
    public static final KnowledgeSourceContentExtractionMode STANDARD = fromString("standard");

    /**
     * Creates a new instance of KnowledgeSourceContentExtractionMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public KnowledgeSourceContentExtractionMode() {
    }

    /**
     * Creates or finds a KnowledgeSourceContentExtractionMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding KnowledgeSourceContentExtractionMode.
     */
    @Generated
    public static KnowledgeSourceContentExtractionMode fromString(String name) {
        return fromString(name, KnowledgeSourceContentExtractionMode.class);
    }

    /**
     * Gets known KnowledgeSourceContentExtractionMode values.
     * 
     * @return known KnowledgeSourceContentExtractionMode values.
     */
    @Generated
    public static Collection<KnowledgeSourceContentExtractionMode> values() {
        return values(KnowledgeSourceContentExtractionMode.class);
    }
}
