// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Consolidates all general ingestion settings for knowledge sources.
 */
@Fluent
public final class KnowledgeSourceIngestionParameters implements JsonSerializable<KnowledgeSourceIngestionParameters> {
    /*
     * An explicit identity to use for this knowledge source.
     */
    @Generated
    private SearchIndexerDataIdentity identity;

    /*
     * Optional vectorizer configuration for vectorizing content.
     */
    @Generated
    private KnowledgeSourceVectorizer embeddingModel;

    /*
     * Optional chat completion model for image verbalization or context extraction.
     */
    @Generated
    private KnowledgeBaseModel chatCompletionModel;

    /*
     * Indicates whether image verbalization should be disabled. Default is false.
     */
    @Generated
    private Boolean disableImageVerbalization;

    /*
     * Optional schedule for data ingestion.
     */
    @Generated
    private IndexingSchedule ingestionSchedule;

    /*
     * Optional list of permission types to ingest together with document content. If specified, it will set the indexer
     * permission options for the data source.
     */
    @Generated
    private List<KnowledgeSourceIngestionPermissionOption> ingestionPermissionOptions;

    /*
     * Optional content extraction mode. Default is 'minimal'.
     */
    @Generated
    private KnowledgeSourceContentExtractionMode contentExtractionMode;

    /*
     * Optional AI Services configuration for content processing.
     */
    @Generated
    private AIServices aiServices;

    /**
     * Creates an instance of KnowledgeSourceIngestionParameters class.
     */
    @Generated
    public KnowledgeSourceIngestionParameters() {
    }

    /**
     * Get the identity property: An explicit identity to use for this knowledge source.
     * 
     * @return the identity value.
     */
    @Generated
    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: An explicit identity to use for this knowledge source.
     * 
     * @param identity the identity value to set.
     * @return the KnowledgeSourceIngestionParameters object itself.
     */
    @Generated
    public KnowledgeSourceIngestionParameters setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the embeddingModel property: Optional vectorizer configuration for vectorizing content.
     * 
     * @return the embeddingModel value.
     */
    @Generated
    public KnowledgeSourceVectorizer getEmbeddingModel() {
        return this.embeddingModel;
    }

    /**
     * Set the embeddingModel property: Optional vectorizer configuration for vectorizing content.
     * 
     * @param embeddingModel the embeddingModel value to set.
     * @return the KnowledgeSourceIngestionParameters object itself.
     */
    @Generated
    public KnowledgeSourceIngestionParameters setEmbeddingModel(KnowledgeSourceVectorizer embeddingModel) {
        this.embeddingModel = embeddingModel;
        return this;
    }

    /**
     * Get the chatCompletionModel property: Optional chat completion model for image verbalization or context
     * extraction.
     * 
     * @return the chatCompletionModel value.
     */
    @Generated
    public KnowledgeBaseModel getChatCompletionModel() {
        return this.chatCompletionModel;
    }

    /**
     * Set the chatCompletionModel property: Optional chat completion model for image verbalization or context
     * extraction.
     * 
     * @param chatCompletionModel the chatCompletionModel value to set.
     * @return the KnowledgeSourceIngestionParameters object itself.
     */
    @Generated
    public KnowledgeSourceIngestionParameters setChatCompletionModel(KnowledgeBaseModel chatCompletionModel) {
        this.chatCompletionModel = chatCompletionModel;
        return this;
    }

    /**
     * Get the disableImageVerbalization property: Indicates whether image verbalization should be disabled. Default is
     * false.
     * 
     * @return the disableImageVerbalization value.
     */
    @Generated
    public Boolean isDisableImageVerbalization() {
        return this.disableImageVerbalization;
    }

    /**
     * Set the disableImageVerbalization property: Indicates whether image verbalization should be disabled. Default is
     * false.
     * 
     * @param disableImageVerbalization the disableImageVerbalization value to set.
     * @return the KnowledgeSourceIngestionParameters object itself.
     */
    @Generated
    public KnowledgeSourceIngestionParameters setDisableImageVerbalization(Boolean disableImageVerbalization) {
        this.disableImageVerbalization = disableImageVerbalization;
        return this;
    }

    /**
     * Get the ingestionSchedule property: Optional schedule for data ingestion.
     * 
     * @return the ingestionSchedule value.
     */
    @Generated
    public IndexingSchedule getIngestionSchedule() {
        return this.ingestionSchedule;
    }

    /**
     * Set the ingestionSchedule property: Optional schedule for data ingestion.
     * 
     * @param ingestionSchedule the ingestionSchedule value to set.
     * @return the KnowledgeSourceIngestionParameters object itself.
     */
    @Generated
    public KnowledgeSourceIngestionParameters setIngestionSchedule(IndexingSchedule ingestionSchedule) {
        this.ingestionSchedule = ingestionSchedule;
        return this;
    }

    /**
     * Get the ingestionPermissionOptions property: Optional list of permission types to ingest together with document
     * content. If specified, it will set the indexer permission options for the data source.
     * 
     * @return the ingestionPermissionOptions value.
     */
    @Generated
    public List<KnowledgeSourceIngestionPermissionOption> getIngestionPermissionOptions() {
        return this.ingestionPermissionOptions;
    }

    /**
     * Set the ingestionPermissionOptions property: Optional list of permission types to ingest together with document
     * content. If specified, it will set the indexer permission options for the data source.
     * 
     * @param ingestionPermissionOptions the ingestionPermissionOptions value to set.
     * @return the KnowledgeSourceIngestionParameters object itself.
     */
    @Generated
    public KnowledgeSourceIngestionParameters
        setIngestionPermissionOptions(List<KnowledgeSourceIngestionPermissionOption> ingestionPermissionOptions) {
        this.ingestionPermissionOptions = ingestionPermissionOptions;
        return this;
    }

    /**
     * Get the contentExtractionMode property: Optional content extraction mode. Default is 'minimal'.
     * 
     * @return the contentExtractionMode value.
     */
    @Generated
    public KnowledgeSourceContentExtractionMode getContentExtractionMode() {
        return this.contentExtractionMode;
    }

    /**
     * Set the contentExtractionMode property: Optional content extraction mode. Default is 'minimal'.
     * 
     * @param contentExtractionMode the contentExtractionMode value to set.
     * @return the KnowledgeSourceIngestionParameters object itself.
     */
    @Generated
    public KnowledgeSourceIngestionParameters
        setContentExtractionMode(KnowledgeSourceContentExtractionMode contentExtractionMode) {
        this.contentExtractionMode = contentExtractionMode;
        return this;
    }

    /**
     * Get the aiServices property: Optional AI Services configuration for content processing.
     * 
     * @return the aiServices value.
     */
    @Generated
    public AIServices getAiServices() {
        return this.aiServices;
    }

    /**
     * Set the aiServices property: Optional AI Services configuration for content processing.
     * 
     * @param aiServices the aiServices value to set.
     * @return the KnowledgeSourceIngestionParameters object itself.
     */
    @Generated
    public KnowledgeSourceIngestionParameters setAiServices(AIServices aiServices) {
        this.aiServices = aiServices;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("embeddingModel", this.embeddingModel);
        jsonWriter.writeJsonField("chatCompletionModel", this.chatCompletionModel);
        jsonWriter.writeBooleanField("disableImageVerbalization", this.disableImageVerbalization);
        jsonWriter.writeJsonField("ingestionSchedule", this.ingestionSchedule);
        jsonWriter.writeArrayField("ingestionPermissionOptions", this.ingestionPermissionOptions,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("contentExtractionMode",
            this.contentExtractionMode == null ? null : this.contentExtractionMode.toString());
        jsonWriter.writeJsonField("aiServices", this.aiServices);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeSourceIngestionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeSourceIngestionParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeSourceIngestionParameters.
     */
    @Generated
    public static KnowledgeSourceIngestionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeSourceIngestionParameters deserializedKnowledgeSourceIngestionParameters
                = new KnowledgeSourceIngestionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identity".equals(fieldName)) {
                    deserializedKnowledgeSourceIngestionParameters.identity
                        = SearchIndexerDataIdentity.fromJson(reader);
                } else if ("embeddingModel".equals(fieldName)) {
                    deserializedKnowledgeSourceIngestionParameters.embeddingModel
                        = KnowledgeSourceVectorizer.fromJson(reader);
                } else if ("chatCompletionModel".equals(fieldName)) {
                    deserializedKnowledgeSourceIngestionParameters.chatCompletionModel
                        = KnowledgeBaseModel.fromJson(reader);
                } else if ("disableImageVerbalization".equals(fieldName)) {
                    deserializedKnowledgeSourceIngestionParameters.disableImageVerbalization
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("ingestionSchedule".equals(fieldName)) {
                    deserializedKnowledgeSourceIngestionParameters.ingestionSchedule
                        = IndexingSchedule.fromJson(reader);
                } else if ("ingestionPermissionOptions".equals(fieldName)) {
                    List<KnowledgeSourceIngestionPermissionOption> ingestionPermissionOptions = reader
                        .readArray(reader1 -> KnowledgeSourceIngestionPermissionOption.fromString(reader1.getString()));
                    deserializedKnowledgeSourceIngestionParameters.ingestionPermissionOptions
                        = ingestionPermissionOptions;
                } else if ("contentExtractionMode".equals(fieldName)) {
                    deserializedKnowledgeSourceIngestionParameters.contentExtractionMode
                        = KnowledgeSourceContentExtractionMode.fromString(reader.getString());
                } else if ("aiServices".equals(fieldName)) {
                    deserializedKnowledgeSourceIngestionParameters.aiServices = AIServices.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeSourceIngestionParameters;
        });
    }
}
