// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Statistical information about knowledge source synchronization history.
 */
@Immutable
public final class KnowledgeSourceStatistics implements JsonSerializable<KnowledgeSourceStatistics> {
    /*
     * The total number of synchronizations completed.
     */
    @Generated
    private final int totalSynchronization;

    /*
     * The average duration of synchronizations in HH:MM:SS format.
     */
    @Generated
    private final String averageSynchronizationDuration;

    /*
     * The average number of items processed per synchronization.
     */
    @Generated
    private final int averageItemsProcessedPerSynchronization;

    /**
     * Creates an instance of KnowledgeSourceStatistics class.
     * 
     * @param totalSynchronization the totalSynchronization value to set.
     * @param averageSynchronizationDuration the averageSynchronizationDuration value to set.
     * @param averageItemsProcessedPerSynchronization the averageItemsProcessedPerSynchronization value to set.
     */
    @Generated
    public KnowledgeSourceStatistics(int totalSynchronization, String averageSynchronizationDuration,
        int averageItemsProcessedPerSynchronization) {
        this.totalSynchronization = totalSynchronization;
        this.averageSynchronizationDuration = averageSynchronizationDuration;
        this.averageItemsProcessedPerSynchronization = averageItemsProcessedPerSynchronization;
    }

    /**
     * Get the totalSynchronization property: The total number of synchronizations completed.
     * 
     * @return the totalSynchronization value.
     */
    @Generated
    public int getTotalSynchronization() {
        return this.totalSynchronization;
    }

    /**
     * Get the averageSynchronizationDuration property: The average duration of synchronizations in HH:MM:SS format.
     * 
     * @return the averageSynchronizationDuration value.
     */
    @Generated
    public String getAverageSynchronizationDuration() {
        return this.averageSynchronizationDuration;
    }

    /**
     * Get the averageItemsProcessedPerSynchronization property: The average number of items processed per
     * synchronization.
     * 
     * @return the averageItemsProcessedPerSynchronization value.
     */
    @Generated
    public int getAverageItemsProcessedPerSynchronization() {
        return this.averageItemsProcessedPerSynchronization;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("totalSynchronization", this.totalSynchronization);
        jsonWriter.writeStringField("averageSynchronizationDuration", this.averageSynchronizationDuration);
        jsonWriter.writeIntField("averageItemsProcessedPerSynchronization",
            this.averageItemsProcessedPerSynchronization);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeSourceStatistics from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeSourceStatistics if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeSourceStatistics.
     */
    @Generated
    public static KnowledgeSourceStatistics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean totalSynchronizationFound = false;
            int totalSynchronization = 0;
            boolean averageSynchronizationDurationFound = false;
            String averageSynchronizationDuration = null;
            boolean averageItemsProcessedPerSynchronizationFound = false;
            int averageItemsProcessedPerSynchronization = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("totalSynchronization".equals(fieldName)) {
                    totalSynchronization = reader.getInt();
                    totalSynchronizationFound = true;
                } else if ("averageSynchronizationDuration".equals(fieldName)) {
                    averageSynchronizationDuration = reader.getString();
                    averageSynchronizationDurationFound = true;
                } else if ("averageItemsProcessedPerSynchronization".equals(fieldName)) {
                    averageItemsProcessedPerSynchronization = reader.getInt();
                    averageItemsProcessedPerSynchronizationFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (totalSynchronizationFound
                && averageSynchronizationDurationFound
                && averageItemsProcessedPerSynchronizationFound) {
                return new KnowledgeSourceStatistics(totalSynchronization, averageSynchronizationDuration,
                    averageItemsProcessedPerSynchronization);
            }
            List<String> missingProperties = new ArrayList<>();
            if (!totalSynchronizationFound) {
                missingProperties.add("totalSynchronization");
            }
            if (!averageSynchronizationDurationFound) {
                missingProperties.add("averageSynchronizationDuration");
            }
            if (!averageItemsProcessedPerSynchronizationFound) {
                missingProperties.add("averageItemsProcessedPerSynchronization");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
