// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the status and synchronization history of a knowledge source.
 */
@Fluent
public final class KnowledgeSourceStatus implements JsonSerializable<KnowledgeSourceStatus> {
    /*
     * The current synchronization status of the knowledge source.
     */
    @Generated
    private final KnowledgeSourceSynchronizationStatus synchronizationStatus;

    /*
     * The synchronization interval (e.g., '1d' for daily). Null if no schedule is configured.
     */
    @Generated
    private String synchronizationInterval;

    /*
     * Current synchronization state that spans multiple indexer runs.
     */
    @Generated
    private SynchronizationState currentSynchronizationState;

    /*
     * Details of the last completed synchronization. Null on first sync.
     */
    @Generated
    private CompletedSynchronizationState lastSynchronizationState;

    /*
     * Statistical information about the knowledge source synchronization history. Null on first sync.
     */
    @Generated
    private KnowledgeSourceStatistics statistics;

    /**
     * Creates an instance of KnowledgeSourceStatus class.
     * 
     * @param synchronizationStatus the synchronizationStatus value to set.
     */
    @Generated
    public KnowledgeSourceStatus(KnowledgeSourceSynchronizationStatus synchronizationStatus) {
        this.synchronizationStatus = synchronizationStatus;
    }

    /**
     * Get the synchronizationStatus property: The current synchronization status of the knowledge source.
     * 
     * @return the synchronizationStatus value.
     */
    @Generated
    public KnowledgeSourceSynchronizationStatus getSynchronizationStatus() {
        return this.synchronizationStatus;
    }

    /**
     * Get the synchronizationInterval property: The synchronization interval (e.g., '1d' for daily). Null if no
     * schedule is configured.
     * 
     * @return the synchronizationInterval value.
     */
    @Generated
    public String getSynchronizationInterval() {
        return this.synchronizationInterval;
    }

    /**
     * Set the synchronizationInterval property: The synchronization interval (e.g., '1d' for daily). Null if no
     * schedule is configured.
     * 
     * @param synchronizationInterval the synchronizationInterval value to set.
     * @return the KnowledgeSourceStatus object itself.
     */
    @Generated
    public KnowledgeSourceStatus setSynchronizationInterval(String synchronizationInterval) {
        this.synchronizationInterval = synchronizationInterval;
        return this;
    }

    /**
     * Get the currentSynchronizationState property: Current synchronization state that spans multiple indexer runs.
     * 
     * @return the currentSynchronizationState value.
     */
    @Generated
    public SynchronizationState getCurrentSynchronizationState() {
        return this.currentSynchronizationState;
    }

    /**
     * Set the currentSynchronizationState property: Current synchronization state that spans multiple indexer runs.
     * 
     * @param currentSynchronizationState the currentSynchronizationState value to set.
     * @return the KnowledgeSourceStatus object itself.
     */
    @Generated
    public KnowledgeSourceStatus setCurrentSynchronizationState(SynchronizationState currentSynchronizationState) {
        this.currentSynchronizationState = currentSynchronizationState;
        return this;
    }

    /**
     * Get the lastSynchronizationState property: Details of the last completed synchronization. Null on first sync.
     * 
     * @return the lastSynchronizationState value.
     */
    @Generated
    public CompletedSynchronizationState getLastSynchronizationState() {
        return this.lastSynchronizationState;
    }

    /**
     * Set the lastSynchronizationState property: Details of the last completed synchronization. Null on first sync.
     * 
     * @param lastSynchronizationState the lastSynchronizationState value to set.
     * @return the KnowledgeSourceStatus object itself.
     */
    @Generated
    public KnowledgeSourceStatus setLastSynchronizationState(CompletedSynchronizationState lastSynchronizationState) {
        this.lastSynchronizationState = lastSynchronizationState;
        return this;
    }

    /**
     * Get the statistics property: Statistical information about the knowledge source synchronization history. Null on
     * first sync.
     * 
     * @return the statistics value.
     */
    @Generated
    public KnowledgeSourceStatistics getStatistics() {
        return this.statistics;
    }

    /**
     * Set the statistics property: Statistical information about the knowledge source synchronization history. Null on
     * first sync.
     * 
     * @param statistics the statistics value to set.
     * @return the KnowledgeSourceStatus object itself.
     */
    @Generated
    public KnowledgeSourceStatus setStatistics(KnowledgeSourceStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("synchronizationStatus",
            this.synchronizationStatus == null ? null : this.synchronizationStatus.toString());
        jsonWriter.writeStringField("synchronizationInterval", this.synchronizationInterval);
        jsonWriter.writeJsonField("currentSynchronizationState", this.currentSynchronizationState);
        jsonWriter.writeJsonField("lastSynchronizationState", this.lastSynchronizationState);
        jsonWriter.writeJsonField("statistics", this.statistics);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeSourceStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeSourceStatus if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeSourceStatus.
     */
    @Generated
    public static KnowledgeSourceStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean synchronizationStatusFound = false;
            KnowledgeSourceSynchronizationStatus synchronizationStatus = null;
            String synchronizationInterval = null;
            SynchronizationState currentSynchronizationState = null;
            CompletedSynchronizationState lastSynchronizationState = null;
            KnowledgeSourceStatistics statistics = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("synchronizationStatus".equals(fieldName)) {
                    synchronizationStatus = KnowledgeSourceSynchronizationStatus.fromString(reader.getString());
                    synchronizationStatusFound = true;
                } else if ("synchronizationInterval".equals(fieldName)) {
                    synchronizationInterval = reader.getString();
                } else if ("currentSynchronizationState".equals(fieldName)) {
                    currentSynchronizationState = SynchronizationState.fromJson(reader);
                } else if ("lastSynchronizationState".equals(fieldName)) {
                    lastSynchronizationState = CompletedSynchronizationState.fromJson(reader);
                } else if ("statistics".equals(fieldName)) {
                    statistics = KnowledgeSourceStatistics.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (synchronizationStatusFound) {
                KnowledgeSourceStatus deserializedKnowledgeSourceStatus
                    = new KnowledgeSourceStatus(synchronizationStatus);
                deserializedKnowledgeSourceStatus.synchronizationInterval = synchronizationInterval;
                deserializedKnowledgeSourceStatus.currentSynchronizationState = currentSynchronizationState;
                deserializedKnowledgeSourceStatus.lastSynchronizationState = lastSynchronizationState;
                deserializedKnowledgeSourceStatus.statistics = statistics;

                return deserializedKnowledgeSourceStatus;
            }
            throw new IllegalStateException("Missing required property: synchronizationStatus");
        });
    }
}
