// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The current synchronization status of the knowledge source.
 */
public final class KnowledgeSourceSynchronizationStatus
    extends ExpandableStringEnum<KnowledgeSourceSynchronizationStatus> {
    /**
     * The knowledge source is being provisioned.
     */
    @Generated
    public static final KnowledgeSourceSynchronizationStatus CREATING = fromString("creating");

    /**
     * The knowledge source is active and synchronization runs are occurring.
     */
    @Generated
    public static final KnowledgeSourceSynchronizationStatus ACTIVE = fromString("active");

    /**
     * The knowledge source is being deleted and synchronization is paused.
     */
    @Generated
    public static final KnowledgeSourceSynchronizationStatus DELETING = fromString("deleting");

    /**
     * Creates a new instance of KnowledgeSourceSynchronizationStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public KnowledgeSourceSynchronizationStatus() {
    }

    /**
     * Creates or finds a KnowledgeSourceSynchronizationStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding KnowledgeSourceSynchronizationStatus.
     */
    @Generated
    public static KnowledgeSourceSynchronizationStatus fromString(String name) {
        return fromString(name, KnowledgeSourceSynchronizationStatus.class);
    }

    /**
     * Gets known KnowledgeSourceSynchronizationStatus values.
     * 
     * @return known KnowledgeSourceSynchronizationStatus values.
     */
    @Generated
    public static Collection<KnowledgeSourceSynchronizationStatus> values() {
        return values(KnowledgeSourceSynchronizationStatus.class);
    }
}
