// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the vectorization method to be used for knowledge source embedding model, with optional name.
 */
@Immutable
public class KnowledgeSourceVectorizer implements JsonSerializable<KnowledgeSourceVectorizer> {
    /*
     * The name of the kind of vectorization method being configured for use with vector search.
     */
    @Generated
    private VectorSearchVectorizerKind kind = VectorSearchVectorizerKind.fromString("KnowledgeSourceVectorizer");

    /**
     * Creates an instance of KnowledgeSourceVectorizer class.
     */
    @Generated
    public KnowledgeSourceVectorizer() {
    }

    /**
     * Get the kind property: The name of the kind of vectorization method being configured for use with vector search.
     * 
     * @return the kind value.
     */
    @Generated
    public VectorSearchVectorizerKind getKind() {
        return this.kind;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeSourceVectorizer from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeSourceVectorizer if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeSourceVectorizer.
     */
    @Generated
    public static KnowledgeSourceVectorizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("azureOpenAI".equals(discriminatorValue)) {
                    return KnowledgeSourceAzureOpenAIVectorizer.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeSourceVectorizer fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeSourceVectorizer deserializedKnowledgeSourceVectorizer = new KnowledgeSourceVectorizer();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedKnowledgeSourceVectorizer.kind
                        = VectorSearchVectorizerKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeSourceVectorizer;
        });
    }
}
