// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A character filter that replaces characters in the input string. It uses a regular expression to identify character
 * sequences to preserve and a replacement pattern to identify characters to replace. For example, given the input text
 * "aa bb aa bb", pattern "(aa)\s+(bb)", and replacement "$1#$2", the result would be "aa#bb aa#bb". This character
 * filter is implemented using Apache Lucene.
 */
@Immutable
public final class PatternReplaceCharFilter extends CharFilter {
    /*
     * A URI fragment specifying the type of char filter.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.PatternReplaceCharFilter";

    /*
     * A regular expression pattern.
     */
    @Generated
    private final String pattern;

    /*
     * The replacement text.
     */
    @Generated
    private final String replacement;

    /**
     * Creates an instance of PatternReplaceCharFilter class.
     * 
     * @param name the name value to set.
     * @param pattern the pattern value to set.
     * @param replacement the replacement value to set.
     */
    @Generated
    public PatternReplaceCharFilter(String name, String pattern, String replacement) {
        super(name);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of char filter.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the pattern property: A regular expression pattern.
     * 
     * @return the pattern value.
     */
    @Generated
    public String getPattern() {
        return this.pattern;
    }

    /**
     * Get the replacement property: The replacement text.
     * 
     * @return the replacement value.
     */
    @Generated
    public String getReplacement() {
        return this.replacement;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("pattern", this.pattern);
        jsonWriter.writeStringField("replacement", this.replacement);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatternReplaceCharFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatternReplaceCharFilter if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PatternReplaceCharFilter.
     */
    @Generated
    public static PatternReplaceCharFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean patternFound = false;
            String pattern = null;
            boolean replacementFound = false;
            String replacement = null;
            String odataType = "#Microsoft.Azure.Search.PatternReplaceCharFilter";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("pattern".equals(fieldName)) {
                    pattern = reader.getString();
                    patternFound = true;
                } else if ("replacement".equals(fieldName)) {
                    replacement = reader.getString();
                    replacementFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && patternFound && replacementFound) {
                PatternReplaceCharFilter deserializedPatternReplaceCharFilter
                    = new PatternReplaceCharFilter(name, pattern, replacement);
                deserializedPatternReplaceCharFilter.odataType = odataType;

                return deserializedPatternReplaceCharFilter;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!patternFound) {
                missingProperties.add("pattern");
            }
            if (!replacementFound) {
                missingProperties.add("replacement");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
