// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Tokenizer that uses regex pattern matching to construct distinct tokens. This tokenizer is implemented using Apache
 * Lucene.
 */
@Fluent
public final class PatternTokenizer extends LexicalTokenizer {

    /*
     * A URI fragment specifying the type of tokenizer.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.PatternTokenizer";

    /*
     * A regular expression pattern to match token separators. Default is an expression that matches one or more
     * non-word characters.
     */
    @Generated
    private String pattern;

    /*
     * Regular expression flags.
     */
    @Generated
    private RegexFlags flags;

    /*
     * The zero-based ordinal of the matching group in the regular expression pattern to extract into tokens. Use -1 if
     * you want to use the entire pattern to split the input into tokens, irrespective of matching groups. Default is
     * -1.
     */
    @Generated
    private Integer group;

    /**
     * Creates an instance of PatternTokenizer class.
     *
     * @param name the name value to set.
     */
    @Generated
    public PatternTokenizer(String name) {
        super(name);
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of tokenizer.
     *
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the pattern property: A regular expression pattern to match token separators. Default is an expression that
     * matches one or more non-word characters.
     *
     * @return the pattern value.
     */
    @Generated
    public String getPattern() {
        return this.pattern;
    }

    /**
     * Set the pattern property: A regular expression pattern to match token separators. Default is an expression that
     * matches one or more non-word characters.
     *
     * @param pattern the pattern value to set.
     * @return the PatternTokenizer object itself.
     */
    @Generated
    public PatternTokenizer setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    /**
     * Get the flags property: Regular expression flags.
     *
     * @return the flags value.
     */
    @Generated
    public List<RegexFlags> getFlags() {
        if (this.flags == null) {
            return null;
        } else {
            String[] flagStrings = this.flags.toString().split("\\|");
            return Arrays.stream(flagStrings).map(RegexFlags::fromString).collect(Collectors.toList());
        }
    }

    /**
     * Set the flags property: Regular expression flags.
     *
     * @param flags the flags value to set.
     * @return the PatternTokenizer object itself.
     */
    @Generated
    public PatternTokenizer setFlags(List<RegexFlags> flags) {
        if (flags == null) {
            this.flags = null;
        } else {
            String flagString = flags.stream().map(RegexFlags::toString).collect(Collectors.joining("|"));
            this.flags = RegexFlags.fromString(flagString);
        }
        return this;
    }

    /**
     * Get the group property: The zero-based ordinal of the matching group in the regular expression pattern to extract
     * into tokens. Use -1 if you want to use the entire pattern to split the input into tokens, irrespective of
     * matching groups. Default is -1.
     *
     * @return the group value.
     */
    @Generated
    public Integer getGroup() {
        return this.group;
    }

    /**
     * Set the group property: The zero-based ordinal of the matching group in the regular expression pattern to extract
     * into tokens. Use -1 if you want to use the entire pattern to split the input into tokens, irrespective of
     * matching groups. Default is -1.
     *
     * @param group the group value to set.
     * @return the PatternTokenizer object itself.
     */
    @Generated
    public PatternTokenizer setGroup(Integer group) {
        this.group = group;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("pattern", this.pattern);
        jsonWriter.writeStringField("flags", this.flags == null ? null : this.flags.toString());
        jsonWriter.writeNumberField("group", this.group);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PatternTokenizer from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PatternTokenizer if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PatternTokenizer.
     */
    @Generated
    public static PatternTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = "#Microsoft.Azure.Search.PatternTokenizer";
            String pattern = null;
            RegexFlags flags = null;
            Integer group = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("pattern".equals(fieldName)) {
                    pattern = reader.getString();
                } else if ("flags".equals(fieldName)) {
                    flags = RegexFlags.fromString(reader.getString());
                } else if ("group".equals(fieldName)) {
                    group = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                PatternTokenizer deserializedPatternTokenizer = new PatternTokenizer(name);
                deserializedPatternTokenizer.odataType = odataType;
                deserializedPatternTokenizer.pattern = pattern;
                deserializedPatternTokenizer.flags = flags;
                deserializedPatternTokenizer.group = group;
                return deserializedPatternTokenizer;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    /**
     * Set the flags property: Regular expression flags.
     *
     * @param flags the flags value to set.
     * @return the PatternTokenizer object itself.
     */
    public PatternTokenizer setFlags(RegexFlags... flags) {
        if (flags == null) {
            this.flags = null;
            return this;
        } else {
            return setFlags(Arrays.asList(flags));
        }
    }
}
