// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * A value indicating whether the field should be used as a permission filter.
 */
public final class PermissionFilter extends ExpandableStringEnum<PermissionFilter> {
    /**
     * Field represents user IDs that should be used to filter document access on queries.
     */
    @Generated
    public static final PermissionFilter USER_IDS = fromString("userIds");

    /**
     * Field represents group IDs that should be used to filter document access on queries.
     */
    @Generated
    public static final PermissionFilter GROUP_IDS = fromString("groupIds");

    /**
     * Field represents an RBAC scope that should be used to filter document access on queries.
     */
    @Generated
    public static final PermissionFilter RBAC_SCOPE = fromString("rbacScope");

    /**
     * Creates a new instance of PermissionFilter value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public PermissionFilter() {
    }

    /**
     * Creates or finds a PermissionFilter from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding PermissionFilter.
     */
    @Generated
    public static PermissionFilter fromString(String name) {
        return fromString(name, PermissionFilter.class);
    }

    /**
     * Gets known PermissionFilter values.
     * 
     * @return known PermissionFilter values.
     */
    @Generated
    public static Collection<PermissionFilter> values() {
        return values(PermissionFilter.class);
    }
}
