// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration for remote SharePoint knowledge source.
 */
@Fluent
public final class RemoteSharePointKnowledgeSource extends KnowledgeSource {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.REMOTE_SHARE_POINT;

    /*
     * The parameters for the knowledge source.
     */
    @Generated
    private RemoteSharePointKnowledgeSourceParameters remoteSharePointParameters;

    /**
     * Creates an instance of RemoteSharePointKnowledgeSource class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public RemoteSharePointKnowledgeSource(String name) {
        super(name);
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the remoteSharePointParameters property: The parameters for the knowledge source.
     * 
     * @return the remoteSharePointParameters value.
     */
    @Generated
    public RemoteSharePointKnowledgeSourceParameters getRemoteSharePointParameters() {
        return this.remoteSharePointParameters;
    }

    /**
     * Set the remoteSharePointParameters property: The parameters for the knowledge source.
     * 
     * @param remoteSharePointParameters the remoteSharePointParameters value to set.
     * @return the RemoteSharePointKnowledgeSource object itself.
     */
    @Generated
    public RemoteSharePointKnowledgeSource
        setRemoteSharePointParameters(RemoteSharePointKnowledgeSourceParameters remoteSharePointParameters) {
        this.remoteSharePointParameters = remoteSharePointParameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public RemoteSharePointKnowledgeSource setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public RemoteSharePointKnowledgeSource setETag(String eTag) {
        super.setETag(eTag);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public RemoteSharePointKnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        super.setEncryptionKey(encryptionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("@odata.etag", getETag());
        jsonWriter.writeJsonField("encryptionKey", getEncryptionKey());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("remoteSharePointParameters", this.remoteSharePointParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RemoteSharePointKnowledgeSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RemoteSharePointKnowledgeSource if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RemoteSharePointKnowledgeSource.
     */
    @Generated
    public static RemoteSharePointKnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.REMOTE_SHARE_POINT;
            RemoteSharePointKnowledgeSourceParameters remoteSharePointParameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                } else if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else if ("remoteSharePointParameters".equals(fieldName)) {
                    remoteSharePointParameters = RemoteSharePointKnowledgeSourceParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                RemoteSharePointKnowledgeSource deserializedRemoteSharePointKnowledgeSource
                    = new RemoteSharePointKnowledgeSource(name);
                deserializedRemoteSharePointKnowledgeSource.setDescription(description);
                deserializedRemoteSharePointKnowledgeSource.setETag(eTag);
                deserializedRemoteSharePointKnowledgeSource.setEncryptionKey(encryptionKey);
                deserializedRemoteSharePointKnowledgeSource.kind = kind;
                deserializedRemoteSharePointKnowledgeSource.remoteSharePointParameters = remoteSharePointParameters;

                return deserializedRemoteSharePointKnowledgeSource;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
