// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for remote SharePoint knowledge source.
 */
@Fluent
public final class RemoteSharePointKnowledgeSourceParameters
    implements JsonSerializable<RemoteSharePointKnowledgeSourceParameters> {
    /*
     * Keyword Query Language (KQL) expression with queryable SharePoint properties and attributes to scope the
     * retrieval before the query runs. See documentation:
     * https://learn.microsoft.com/en-us/sharepoint/dev/general-development/keyword-query-language-kql-syntax-reference
     */
    @Generated
    private String filterExpression;

    /*
     * A list of metadata fields to be returned for each item in the response. Only retrievable metadata properties can
     * be included in this list. By default, no metadata is returned. Optional.
     */
    @Generated
    private List<String> resourceMetadata;

    /*
     * Container ID for SharePoint Embedded connection. When this is null, it will use SharePoint Online.
     */
    @Generated
    private String containerTypeId;

    /**
     * Creates an instance of RemoteSharePointKnowledgeSourceParameters class.
     */
    @Generated
    public RemoteSharePointKnowledgeSourceParameters() {
    }

    /**
     * Get the filterExpression property: Keyword Query Language (KQL) expression with queryable SharePoint properties
     * and attributes to scope the retrieval before the query runs. See documentation:
     * https://learn.microsoft.com/en-us/sharepoint/dev/general-development/keyword-query-language-kql-syntax-reference.
     * 
     * @return the filterExpression value.
     */
    @Generated
    public String getFilterExpression() {
        return this.filterExpression;
    }

    /**
     * Set the filterExpression property: Keyword Query Language (KQL) expression with queryable SharePoint properties
     * and attributes to scope the retrieval before the query runs. See documentation:
     * https://learn.microsoft.com/en-us/sharepoint/dev/general-development/keyword-query-language-kql-syntax-reference.
     * 
     * @param filterExpression the filterExpression value to set.
     * @return the RemoteSharePointKnowledgeSourceParameters object itself.
     */
    @Generated
    public RemoteSharePointKnowledgeSourceParameters setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    /**
     * Get the resourceMetadata property: A list of metadata fields to be returned for each item in the response. Only
     * retrievable metadata properties can be included in this list. By default, no metadata is returned. Optional.
     * 
     * @return the resourceMetadata value.
     */
    @Generated
    public List<String> getResourceMetadata() {
        return this.resourceMetadata;
    }

    /**
     * Set the resourceMetadata property: A list of metadata fields to be returned for each item in the response. Only
     * retrievable metadata properties can be included in this list. By default, no metadata is returned. Optional.
     * 
     * @param resourceMetadata the resourceMetadata value to set.
     * @return the RemoteSharePointKnowledgeSourceParameters object itself.
     */
    @Generated
    public RemoteSharePointKnowledgeSourceParameters setResourceMetadata(List<String> resourceMetadata) {
        this.resourceMetadata = resourceMetadata;
        return this;
    }

    /**
     * Get the containerTypeId property: Container ID for SharePoint Embedded connection. When this is null, it will use
     * SharePoint Online.
     * 
     * @return the containerTypeId value.
     */
    @Generated
    public String getContainerTypeId() {
        return this.containerTypeId;
    }

    /**
     * Set the containerTypeId property: Container ID for SharePoint Embedded connection. When this is null, it will use
     * SharePoint Online.
     * 
     * @param containerTypeId the containerTypeId value to set.
     * @return the RemoteSharePointKnowledgeSourceParameters object itself.
     */
    @Generated
    public RemoteSharePointKnowledgeSourceParameters setContainerTypeId(String containerTypeId) {
        this.containerTypeId = containerTypeId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filterExpression", this.filterExpression);
        jsonWriter.writeArrayField("resourceMetadata", this.resourceMetadata,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("containerTypeId", this.containerTypeId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RemoteSharePointKnowledgeSourceParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RemoteSharePointKnowledgeSourceParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RemoteSharePointKnowledgeSourceParameters.
     */
    @Generated
    public static RemoteSharePointKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RemoteSharePointKnowledgeSourceParameters deserializedRemoteSharePointKnowledgeSourceParameters
                = new RemoteSharePointKnowledgeSourceParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("filterExpression".equals(fieldName)) {
                    deserializedRemoteSharePointKnowledgeSourceParameters.filterExpression = reader.getString();
                } else if ("resourceMetadata".equals(fieldName)) {
                    List<String> resourceMetadata = reader.readArray(reader1 -> reader1.getString());
                    deserializedRemoteSharePointKnowledgeSourceParameters.resourceMetadata = resourceMetadata;
                } else if ("containerTypeId".equals(fieldName)) {
                    deserializedRemoteSharePointKnowledgeSourceParameters.containerTypeId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRemoteSharePointKnowledgeSourceParameters;
        });
    }
}
