// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains the options for rescoring.
 */
@Fluent
public final class RescoringOptions implements JsonSerializable<RescoringOptions> {
    /*
     * If set to true, after the initial search on the compressed vectors, the similarity scores are recalculated using
     * the full-precision vectors. This will improve recall at the expense of latency.
     */
    @Generated
    private Boolean rescoringEnabled;

    /*
     * Default oversampling factor. Oversampling retrieves a greater set of potential documents to offset the resolution
     * loss due to quantization. This increases the set of results that will be rescored on full-precision vectors.
     * Minimum value is 1, meaning no oversampling (1x). This parameter can only be set when 'enableRescoring' is true.
     * Higher values improve recall at the expense of latency.
     */
    @Generated
    private Double defaultOversampling;

    /*
     * Controls the storage method for original vectors. This setting is immutable.
     */
    @Generated
    private VectorSearchCompressionRescoreStorageMethod rescoreStorageMethod;

    /**
     * Creates an instance of RescoringOptions class.
     */
    @Generated
    public RescoringOptions() {
    }

    /**
     * Get the rescoringEnabled property: If set to true, after the initial search on the compressed vectors, the
     * similarity scores are recalculated using the full-precision vectors. This will improve recall at the expense of
     * latency.
     * 
     * @return the rescoringEnabled value.
     */
    @Generated
    public Boolean isRescoringEnabled() {
        return this.rescoringEnabled;
    }

    /**
     * Set the rescoringEnabled property: If set to true, after the initial search on the compressed vectors, the
     * similarity scores are recalculated using the full-precision vectors. This will improve recall at the expense of
     * latency.
     * 
     * @param rescoringEnabled the rescoringEnabled value to set.
     * @return the RescoringOptions object itself.
     */
    @Generated
    public RescoringOptions setRescoringEnabled(Boolean rescoringEnabled) {
        this.rescoringEnabled = rescoringEnabled;
        return this;
    }

    /**
     * Get the defaultOversampling property: Default oversampling factor. Oversampling retrieves a greater set of
     * potential documents to offset the resolution loss due to quantization. This increases the set of results that
     * will be rescored on full-precision vectors. Minimum value is 1, meaning no oversampling (1x). This parameter can
     * only be set when 'enableRescoring' is true. Higher values improve recall at the expense of latency.
     * 
     * @return the defaultOversampling value.
     */
    @Generated
    public Double getDefaultOversampling() {
        return this.defaultOversampling;
    }

    /**
     * Set the defaultOversampling property: Default oversampling factor. Oversampling retrieves a greater set of
     * potential documents to offset the resolution loss due to quantization. This increases the set of results that
     * will be rescored on full-precision vectors. Minimum value is 1, meaning no oversampling (1x). This parameter can
     * only be set when 'enableRescoring' is true. Higher values improve recall at the expense of latency.
     * 
     * @param defaultOversampling the defaultOversampling value to set.
     * @return the RescoringOptions object itself.
     */
    @Generated
    public RescoringOptions setDefaultOversampling(Double defaultOversampling) {
        this.defaultOversampling = defaultOversampling;
        return this;
    }

    /**
     * Get the rescoreStorageMethod property: Controls the storage method for original vectors. This setting is
     * immutable.
     * 
     * @return the rescoreStorageMethod value.
     */
    @Generated
    public VectorSearchCompressionRescoreStorageMethod getRescoreStorageMethod() {
        return this.rescoreStorageMethod;
    }

    /**
     * Set the rescoreStorageMethod property: Controls the storage method for original vectors. This setting is
     * immutable.
     * 
     * @param rescoreStorageMethod the rescoreStorageMethod value to set.
     * @return the RescoringOptions object itself.
     */
    @Generated
    public RescoringOptions setRescoreStorageMethod(VectorSearchCompressionRescoreStorageMethod rescoreStorageMethod) {
        this.rescoreStorageMethod = rescoreStorageMethod;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableRescoring", this.rescoringEnabled);
        jsonWriter.writeNumberField("defaultOversampling", this.defaultOversampling);
        jsonWriter.writeStringField("rescoreStorageMethod",
            this.rescoreStorageMethod == null ? null : this.rescoreStorageMethod.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RescoringOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RescoringOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RescoringOptions.
     */
    @Generated
    public static RescoringOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RescoringOptions deserializedRescoringOptions = new RescoringOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enableRescoring".equals(fieldName)) {
                    deserializedRescoringOptions.rescoringEnabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("defaultOversampling".equals(fieldName)) {
                    deserializedRescoringOptions.defaultOversampling = reader.getNullable(JsonReader::getDouble);
                } else if ("rescoreStorageMethod".equals(fieldName)) {
                    deserializedRescoringOptions.rescoreStorageMethod
                        = VectorSearchCompressionRescoreStorageMethod.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRescoringOptions;
        });
    }
}
