// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a resource's usage and quota.
 */
@Fluent
public final class ResourceCounter implements JsonSerializable<ResourceCounter> {
    /*
     * The resource usage amount.
     */
    @Generated
    private final long usage;

    /*
     * The resource amount quota.
     */
    @Generated
    private Long quota;

    /**
     * Creates an instance of ResourceCounter class.
     * 
     * @param usage the usage value to set.
     */
    @Generated
    public ResourceCounter(long usage) {
        this.usage = usage;
    }

    /**
     * Get the usage property: The resource usage amount.
     * 
     * @return the usage value.
     */
    @Generated
    public long getUsage() {
        return this.usage;
    }

    /**
     * Get the quota property: The resource amount quota.
     * 
     * @return the quota value.
     */
    @Generated
    public Long getQuota() {
        return this.quota;
    }

    /**
     * Set the quota property: The resource amount quota.
     * 
     * @param quota the quota value to set.
     * @return the ResourceCounter object itself.
     */
    @Generated
    public ResourceCounter setQuota(Long quota) {
        this.quota = quota;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("usage", this.usage);
        jsonWriter.writeNumberField("quota", this.quota);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceCounter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceCounter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResourceCounter.
     */
    @Generated
    public static ResourceCounter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean usageFound = false;
            long usage = 0L;
            Long quota = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("usage".equals(fieldName)) {
                    usage = reader.getLong();
                    usageFound = true;
                } else if ("quota".equals(fieldName)) {
                    quota = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }
            if (usageFound) {
                ResourceCounter deserializedResourceCounter = new ResourceCounter(usage);
                deserializedResourceCounter.quota = quota;

                return deserializedResourceCounter;
            }
            throw new IllegalStateException("Missing required property: usage");
        });
    }
}
