// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains the parameters specific to Scalar Quantization.
 */
@Fluent
public final class ScalarQuantizationParameters implements JsonSerializable<ScalarQuantizationParameters> {
    /*
     * The quantized data type of compressed vector values.
     */
    @Generated
    private VectorSearchCompressionTarget quantizedDataType;

    /**
     * Creates an instance of ScalarQuantizationParameters class.
     */
    @Generated
    public ScalarQuantizationParameters() {
    }

    /**
     * Get the quantizedDataType property: The quantized data type of compressed vector values.
     * 
     * @return the quantizedDataType value.
     */
    @Generated
    public VectorSearchCompressionTarget getQuantizedDataType() {
        return this.quantizedDataType;
    }

    /**
     * Set the quantizedDataType property: The quantized data type of compressed vector values.
     * 
     * @param quantizedDataType the quantizedDataType value to set.
     * @return the ScalarQuantizationParameters object itself.
     */
    @Generated
    public ScalarQuantizationParameters setQuantizedDataType(VectorSearchCompressionTarget quantizedDataType) {
        this.quantizedDataType = quantizedDataType;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("quantizedDataType",
            this.quantizedDataType == null ? null : this.quantizedDataType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScalarQuantizationParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScalarQuantizationParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScalarQuantizationParameters.
     */
    @Generated
    public static ScalarQuantizationParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScalarQuantizationParameters deserializedScalarQuantizationParameters = new ScalarQuantizationParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("quantizedDataType".equals(fieldName)) {
                    deserializedScalarQuantizationParameters.quantizedDataType
                        = VectorSearchCompressionTarget.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScalarQuantizationParameters;
        });
    }
}
