// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * Defines parameters for a search index that influence scoring in search queries.
 */
@Fluent
public final class ScoringProfile implements JsonSerializable<ScoringProfile> {

    /*
     * The name of the scoring profile.
     */
    @Generated
    private final String name;

    /*
     * Parameters that boost scoring based on text matches in certain index fields.
     */
    @Generated
    private TextWeights textWeights;

    /*
     * The collection of functions that influence the scoring of documents.
     */
    @Generated
    private List<ScoringFunction> functions;

    /*
     * A value indicating how the results of individual scoring functions should be combined. Defaults to "Sum". Ignored
     * if there are no scoring functions.
     */
    @Generated
    private ScoringFunctionAggregation functionAggregation;

    /**
     * Creates an instance of ScoringProfile class.
     *
     * @param name the name value to set.
     */
    @Generated
    public ScoringProfile(String name) {
        this.name = name;
    }

    /**
     * Get the name property: The name of the scoring profile.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the textWeights property: Parameters that boost scoring based on text matches in certain index fields.
     *
     * @return the textWeights value.
     */
    @Generated
    public TextWeights getTextWeights() {
        return this.textWeights;
    }

    /**
     * Set the textWeights property: Parameters that boost scoring based on text matches in certain index fields.
     *
     * @param textWeights the textWeights value to set.
     * @return the ScoringProfile object itself.
     */
    @Generated
    public ScoringProfile setTextWeights(TextWeights textWeights) {
        this.textWeights = textWeights;
        return this;
    }

    /**
     * Get the functions property: The collection of functions that influence the scoring of documents.
     *
     * @return the functions value.
     */
    @Generated
    public List<ScoringFunction> getFunctions() {
        return this.functions;
    }

    /**
     * Set the functions property: The collection of functions that influence the scoring of documents.
     *
     * @param functions the functions value to set.
     * @return the ScoringProfile object itself.
     */
    @Generated
    public ScoringProfile setFunctions(List<ScoringFunction> functions) {
        this.functions = functions;
        return this;
    }

    /**
     * Get the functionAggregation property: A value indicating how the results of individual scoring functions should
     * be combined. Defaults to "Sum". Ignored if there are no scoring functions.
     *
     * @return the functionAggregation value.
     */
    @Generated
    public ScoringFunctionAggregation getFunctionAggregation() {
        return this.functionAggregation;
    }

    /**
     * Set the functionAggregation property: A value indicating how the results of individual scoring functions should
     * be combined. Defaults to "Sum". Ignored if there are no scoring functions.
     *
     * @param functionAggregation the functionAggregation value to set.
     * @return the ScoringProfile object itself.
     */
    @Generated
    public ScoringProfile setFunctionAggregation(ScoringFunctionAggregation functionAggregation) {
        this.functionAggregation = functionAggregation;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("text", this.textWeights);
        jsonWriter.writeArrayField("functions", this.functions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("functionAggregation",
            this.functionAggregation == null ? null : this.functionAggregation.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScoringProfile from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScoringProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScoringProfile.
     */
    @Generated
    public static ScoringProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            TextWeights textWeights = null;
            List<ScoringFunction> functions = null;
            ScoringFunctionAggregation functionAggregation = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("text".equals(fieldName)) {
                    textWeights = TextWeights.fromJson(reader);
                } else if ("functions".equals(fieldName)) {
                    functions = reader.readArray(reader1 -> ScoringFunction.fromJson(reader1));
                } else if ("functionAggregation".equals(fieldName)) {
                    functionAggregation = ScoringFunctionAggregation.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                ScoringProfile deserializedScoringProfile = new ScoringProfile(name);
                deserializedScoringProfile.textWeights = textWeights;
                deserializedScoringProfile.functions = functions;
                deserializedScoringProfile.functionAggregation = functionAggregation;
                return deserializedScoringProfile;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }

    /**
     * Set the functions property: The collection of functions that influence the scoring of documents.
     *
     * @param functions the functions value to set.
     * @return the ScoringProfile object itself.
     */
    public ScoringProfile setFunctions(ScoringFunction... functions) {
        this.functions = (functions == null) ? null : Arrays.asList(functions);
        return this;
    }
}
