// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for search index knowledge source.
 */
@Fluent
public final class SearchIndexKnowledgeSourceParameters
    implements JsonSerializable<SearchIndexKnowledgeSourceParameters> {
    /*
     * The name of the Search index.
     */
    @Generated
    private final String searchIndexName;

    /*
     * Used to request additional fields for referenced source data.
     */
    @Generated
    private List<SearchIndexFieldReference> sourceDataFields;

    /*
     * Used to restrict which fields to search on the search index.
     */
    @Generated
    private List<SearchIndexFieldReference> searchFields;

    /*
     * Used to specify a different semantic configuration on the target search index other than the default one.
     */
    @Generated
    private String semanticConfigurationName;

    /**
     * Creates an instance of SearchIndexKnowledgeSourceParameters class.
     * 
     * @param searchIndexName the searchIndexName value to set.
     */
    @Generated
    public SearchIndexKnowledgeSourceParameters(String searchIndexName) {
        this.searchIndexName = searchIndexName;
    }

    /**
     * Get the searchIndexName property: The name of the Search index.
     * 
     * @return the searchIndexName value.
     */
    @Generated
    public String getSearchIndexName() {
        return this.searchIndexName;
    }

    /**
     * Get the sourceDataFields property: Used to request additional fields for referenced source data.
     * 
     * @return the sourceDataFields value.
     */
    @Generated
    public List<SearchIndexFieldReference> getSourceDataFields() {
        return this.sourceDataFields;
    }

    /**
     * Set the sourceDataFields property: Used to request additional fields for referenced source data.
     * 
     * @param sourceDataFields the sourceDataFields value to set.
     * @return the SearchIndexKnowledgeSourceParameters object itself.
     */
    @Generated
    public SearchIndexKnowledgeSourceParameters setSourceDataFields(List<SearchIndexFieldReference> sourceDataFields) {
        this.sourceDataFields = sourceDataFields;
        return this;
    }

    /**
     * Get the searchFields property: Used to restrict which fields to search on the search index.
     * 
     * @return the searchFields value.
     */
    @Generated
    public List<SearchIndexFieldReference> getSearchFields() {
        return this.searchFields;
    }

    /**
     * Set the searchFields property: Used to restrict which fields to search on the search index.
     * 
     * @param searchFields the searchFields value to set.
     * @return the SearchIndexKnowledgeSourceParameters object itself.
     */
    @Generated
    public SearchIndexKnowledgeSourceParameters setSearchFields(List<SearchIndexFieldReference> searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    /**
     * Get the semanticConfigurationName property: Used to specify a different semantic configuration on the target
     * search index other than the default one.
     * 
     * @return the semanticConfigurationName value.
     */
    @Generated
    public String getSemanticConfigurationName() {
        return this.semanticConfigurationName;
    }

    /**
     * Set the semanticConfigurationName property: Used to specify a different semantic configuration on the target
     * search index other than the default one.
     * 
     * @param semanticConfigurationName the semanticConfigurationName value to set.
     * @return the SearchIndexKnowledgeSourceParameters object itself.
     */
    @Generated
    public SearchIndexKnowledgeSourceParameters setSemanticConfigurationName(String semanticConfigurationName) {
        this.semanticConfigurationName = semanticConfigurationName;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("searchIndexName", this.searchIndexName);
        jsonWriter.writeArrayField("sourceDataFields", this.sourceDataFields,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("searchFields", this.searchFields, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("semanticConfigurationName", this.semanticConfigurationName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexKnowledgeSourceParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexKnowledgeSourceParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchIndexKnowledgeSourceParameters.
     */
    @Generated
    public static SearchIndexKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean searchIndexNameFound = false;
            String searchIndexName = null;
            List<SearchIndexFieldReference> sourceDataFields = null;
            List<SearchIndexFieldReference> searchFields = null;
            String semanticConfigurationName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("searchIndexName".equals(fieldName)) {
                    searchIndexName = reader.getString();
                    searchIndexNameFound = true;
                } else if ("sourceDataFields".equals(fieldName)) {
                    sourceDataFields = reader.readArray(reader1 -> SearchIndexFieldReference.fromJson(reader1));
                } else if ("searchFields".equals(fieldName)) {
                    searchFields = reader.readArray(reader1 -> SearchIndexFieldReference.fromJson(reader1));
                } else if ("semanticConfigurationName".equals(fieldName)) {
                    semanticConfigurationName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (searchIndexNameFound) {
                SearchIndexKnowledgeSourceParameters deserializedSearchIndexKnowledgeSourceParameters
                    = new SearchIndexKnowledgeSourceParameters(searchIndexName);
                deserializedSearchIndexKnowledgeSourceParameters.sourceDataFields = sourceDataFields;
                deserializedSearchIndexKnowledgeSourceParameters.searchFields = searchFields;
                deserializedSearchIndexKnowledgeSourceParameters.semanticConfigurationName = semanticConfigurationName;

                return deserializedSearchIndexKnowledgeSourceParameters;
            }
            throw new IllegalStateException("Missing required property: searchIndexName");
        });
    }
}
