// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SearchIndexerCache model.
 */
@Fluent
public final class SearchIndexerCache implements JsonSerializable<SearchIndexerCache> {
    /*
     * A guid for the SearchIndexerCache.
     */
    @Generated
    private String id;

    /*
     * The connection string to the storage account where the cache data will be persisted.
     */
    @Generated
    private String storageConnectionString;

    /*
     * Specifies whether incremental reprocessing is enabled.
     */
    @Generated
    private Boolean enableReprocessing;

    /*
     * The user-assigned managed identity used for connections to the enrichment cache. If the connection string
     * indicates an identity (ResourceId) and it's not specified, the system-assigned managed identity is used. On
     * updates to the indexer, if the identity is unspecified, the value remains unchanged. If set to "none", the value
     * of this property is cleared.
     */
    @Generated
    private SearchIndexerDataIdentity identity;

    /**
     * Creates an instance of SearchIndexerCache class.
     */
    @Generated
    public SearchIndexerCache() {
    }

    /**
     * Get the id property: A guid for the SearchIndexerCache.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: A guid for the SearchIndexerCache.
     * 
     * @param id the id value to set.
     * @return the SearchIndexerCache object itself.
     */
    @Generated
    public SearchIndexerCache setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the storageConnectionString property: The connection string to the storage account where the cache data will
     * be persisted.
     * 
     * @return the storageConnectionString value.
     */
    @Generated
    public String getStorageConnectionString() {
        return this.storageConnectionString;
    }

    /**
     * Set the storageConnectionString property: The connection string to the storage account where the cache data will
     * be persisted.
     * 
     * @param storageConnectionString the storageConnectionString value to set.
     * @return the SearchIndexerCache object itself.
     */
    @Generated
    public SearchIndexerCache setStorageConnectionString(String storageConnectionString) {
        this.storageConnectionString = storageConnectionString;
        return this;
    }

    /**
     * Get the enableReprocessing property: Specifies whether incremental reprocessing is enabled.
     * 
     * @return the enableReprocessing value.
     */
    @Generated
    public Boolean isEnableReprocessing() {
        return this.enableReprocessing;
    }

    /**
     * Set the enableReprocessing property: Specifies whether incremental reprocessing is enabled.
     * 
     * @param enableReprocessing the enableReprocessing value to set.
     * @return the SearchIndexerCache object itself.
     */
    @Generated
    public SearchIndexerCache setEnableReprocessing(Boolean enableReprocessing) {
        this.enableReprocessing = enableReprocessing;
        return this;
    }

    /**
     * Get the identity property: The user-assigned managed identity used for connections to the enrichment cache. If
     * the connection string indicates an identity (ResourceId) and it's not specified, the system-assigned managed
     * identity is used. On updates to the indexer, if the identity is unspecified, the value remains unchanged. If set
     * to "none", the value of this property is cleared.
     * 
     * @return the identity value.
     */
    @Generated
    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: The user-assigned managed identity used for connections to the enrichment cache. If
     * the connection string indicates an identity (ResourceId) and it's not specified, the system-assigned managed
     * identity is used. On updates to the indexer, if the identity is unspecified, the value remains unchanged. If set
     * to "none", the value of this property is cleared.
     * 
     * @param identity the identity value to set.
     * @return the SearchIndexerCache object itself.
     */
    @Generated
    public SearchIndexerCache setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("storageConnectionString", this.storageConnectionString);
        jsonWriter.writeBooleanField("enableReprocessing", this.enableReprocessing);
        jsonWriter.writeJsonField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerCache from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerCache if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SearchIndexerCache.
     */
    @Generated
    public static SearchIndexerCache fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchIndexerCache deserializedSearchIndexerCache = new SearchIndexerCache();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSearchIndexerCache.id = reader.getString();
                } else if ("storageConnectionString".equals(fieldName)) {
                    deserializedSearchIndexerCache.storageConnectionString = reader.getString();
                } else if ("enableReprocessing".equals(fieldName)) {
                    deserializedSearchIndexerCache.enableReprocessing = reader.getNullable(JsonReader::getBoolean);
                } else if ("identity".equals(fieldName)) {
                    deserializedSearchIndexerCache.identity = SearchIndexerDataIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchIndexerCache;
        });
    }
}
