// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Definition of additional projections to azure blob, table, or files, of enriched data.
 */
@Fluent
public final class SearchIndexerKnowledgeStore implements JsonSerializable<SearchIndexerKnowledgeStore> {
    /*
     * The connection string to the storage account projections will be stored in.
     */
    @Generated
    private final String storageConnectionString;

    /*
     * A list of additional projections to perform during indexing.
     */
    @Generated
    private final List<SearchIndexerKnowledgeStoreProjection> projections;

    /*
     * The user-assigned managed identity used for connections to Azure Storage when writing knowledge store
     * projections. If the connection string indicates an identity (ResourceId) and it's not specified, the
     * system-assigned managed identity is used. On updates to the indexer, if the identity is unspecified, the value
     * remains unchanged. If set to "none", the value of this property is cleared.
     */
    @Generated
    private SearchIndexerDataIdentity identity;

    /*
     * A dictionary of knowledge store-specific configuration properties. Each name is the name of a specific property.
     * Each value must be of a primitive type.
     */
    @Generated
    private SearchIndexerKnowledgeStoreParameters parameters;

    /**
     * Creates an instance of SearchIndexerKnowledgeStore class.
     * 
     * @param storageConnectionString the storageConnectionString value to set.
     * @param projections the projections value to set.
     */
    @Generated
    public SearchIndexerKnowledgeStore(String storageConnectionString,
        List<SearchIndexerKnowledgeStoreProjection> projections) {
        this.storageConnectionString = storageConnectionString;
        this.projections = projections;
    }

    /**
     * Get the storageConnectionString property: The connection string to the storage account projections will be stored
     * in.
     * 
     * @return the storageConnectionString value.
     */
    @Generated
    public String getStorageConnectionString() {
        return this.storageConnectionString;
    }

    /**
     * Get the projections property: A list of additional projections to perform during indexing.
     * 
     * @return the projections value.
     */
    @Generated
    public List<SearchIndexerKnowledgeStoreProjection> getProjections() {
        return this.projections;
    }

    /**
     * Get the identity property: The user-assigned managed identity used for connections to Azure Storage when writing
     * knowledge store projections. If the connection string indicates an identity (ResourceId) and it's not specified,
     * the system-assigned managed identity is used. On updates to the indexer, if the identity is unspecified, the
     * value remains unchanged. If set to "none", the value of this property is cleared.
     * 
     * @return the identity value.
     */
    @Generated
    public SearchIndexerDataIdentity getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: The user-assigned managed identity used for connections to Azure Storage when writing
     * knowledge store projections. If the connection string indicates an identity (ResourceId) and it's not specified,
     * the system-assigned managed identity is used. On updates to the indexer, if the identity is unspecified, the
     * value remains unchanged. If set to "none", the value of this property is cleared.
     * 
     * @param identity the identity value to set.
     * @return the SearchIndexerKnowledgeStore object itself.
     */
    @Generated
    public SearchIndexerKnowledgeStore setIdentity(SearchIndexerDataIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the parameters property: A dictionary of knowledge store-specific configuration properties. Each name is the
     * name of a specific property. Each value must be of a primitive type.
     * 
     * @return the parameters value.
     */
    @Generated
    public SearchIndexerKnowledgeStoreParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: A dictionary of knowledge store-specific configuration properties. Each name is the
     * name of a specific property. Each value must be of a primitive type.
     * 
     * @param parameters the parameters value to set.
     * @return the SearchIndexerKnowledgeStore object itself.
     */
    @Generated
    public SearchIndexerKnowledgeStore setParameters(SearchIndexerKnowledgeStoreParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageConnectionString", this.storageConnectionString);
        jsonWriter.writeArrayField("projections", this.projections, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("parameters", this.parameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerKnowledgeStore from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerKnowledgeStore if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SearchIndexerKnowledgeStore.
     */
    @Generated
    public static SearchIndexerKnowledgeStore fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean storageConnectionStringFound = false;
            String storageConnectionString = null;
            boolean projectionsFound = false;
            List<SearchIndexerKnowledgeStoreProjection> projections = null;
            SearchIndexerDataIdentity identity = null;
            SearchIndexerKnowledgeStoreParameters parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageConnectionString".equals(fieldName)) {
                    storageConnectionString = reader.getString();
                    storageConnectionStringFound = true;
                } else if ("projections".equals(fieldName)) {
                    projections = reader.readArray(reader1 -> SearchIndexerKnowledgeStoreProjection.fromJson(reader1));
                    projectionsFound = true;
                } else if ("identity".equals(fieldName)) {
                    identity = SearchIndexerDataIdentity.fromJson(reader);
                } else if ("parameters".equals(fieldName)) {
                    parameters = SearchIndexerKnowledgeStoreParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (storageConnectionStringFound && projectionsFound) {
                SearchIndexerKnowledgeStore deserializedSearchIndexerKnowledgeStore
                    = new SearchIndexerKnowledgeStore(storageConnectionString, projections);
                deserializedSearchIndexerKnowledgeStore.identity = identity;
                deserializedSearchIndexerKnowledgeStore.parameters = parameters;

                return deserializedSearchIndexerKnowledgeStore;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!storageConnectionStringFound) {
                missingProperties.add("storageConnectionString");
            }
            if (!projectionsFound) {
                missingProperties.add("projections");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
