// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Container object for various projection selectors.
 */
@Fluent
public final class SearchIndexerKnowledgeStoreProjection
    implements JsonSerializable<SearchIndexerKnowledgeStoreProjection> {
    /*
     * Projections to Azure Table storage.
     */
    @Generated
    private List<SearchIndexerKnowledgeStoreTableProjectionSelector> tables;

    /*
     * Projections to Azure Blob storage.
     */
    @Generated
    private List<SearchIndexerKnowledgeStoreObjectProjectionSelector> objects;

    /*
     * Projections to Azure File storage.
     */
    @Generated
    private List<SearchIndexerKnowledgeStoreFileProjectionSelector> files;

    /**
     * Creates an instance of SearchIndexerKnowledgeStoreProjection class.
     */
    @Generated
    public SearchIndexerKnowledgeStoreProjection() {
    }

    /**
     * Get the tables property: Projections to Azure Table storage.
     * 
     * @return the tables value.
     */
    @Generated
    public List<SearchIndexerKnowledgeStoreTableProjectionSelector> getTables() {
        return this.tables;
    }

    /**
     * Set the tables property: Projections to Azure Table storage.
     * 
     * @param tables the tables value to set.
     * @return the SearchIndexerKnowledgeStoreProjection object itself.
     */
    @Generated
    public SearchIndexerKnowledgeStoreProjection
        setTables(List<SearchIndexerKnowledgeStoreTableProjectionSelector> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Get the objects property: Projections to Azure Blob storage.
     * 
     * @return the objects value.
     */
    @Generated
    public List<SearchIndexerKnowledgeStoreObjectProjectionSelector> getObjects() {
        return this.objects;
    }

    /**
     * Set the objects property: Projections to Azure Blob storage.
     * 
     * @param objects the objects value to set.
     * @return the SearchIndexerKnowledgeStoreProjection object itself.
     */
    @Generated
    public SearchIndexerKnowledgeStoreProjection
        setObjects(List<SearchIndexerKnowledgeStoreObjectProjectionSelector> objects) {
        this.objects = objects;
        return this;
    }

    /**
     * Get the files property: Projections to Azure File storage.
     * 
     * @return the files value.
     */
    @Generated
    public List<SearchIndexerKnowledgeStoreFileProjectionSelector> getFiles() {
        return this.files;
    }

    /**
     * Set the files property: Projections to Azure File storage.
     * 
     * @param files the files value to set.
     * @return the SearchIndexerKnowledgeStoreProjection object itself.
     */
    @Generated
    public SearchIndexerKnowledgeStoreProjection
        setFiles(List<SearchIndexerKnowledgeStoreFileProjectionSelector> files) {
        this.files = files;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("objects", this.objects, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("files", this.files, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchIndexerKnowledgeStoreProjection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchIndexerKnowledgeStoreProjection if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SearchIndexerKnowledgeStoreProjection.
     */
    @Generated
    public static SearchIndexerKnowledgeStoreProjection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchIndexerKnowledgeStoreProjection deserializedSearchIndexerKnowledgeStoreProjection
                = new SearchIndexerKnowledgeStoreProjection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tables".equals(fieldName)) {
                    List<SearchIndexerKnowledgeStoreTableProjectionSelector> tables = reader
                        .readArray(reader1 -> SearchIndexerKnowledgeStoreTableProjectionSelector.fromJson(reader1));
                    deserializedSearchIndexerKnowledgeStoreProjection.tables = tables;
                } else if ("objects".equals(fieldName)) {
                    List<SearchIndexerKnowledgeStoreObjectProjectionSelector> objects = reader
                        .readArray(reader1 -> SearchIndexerKnowledgeStoreObjectProjectionSelector.fromJson(reader1));
                    deserializedSearchIndexerKnowledgeStoreProjection.objects = objects;
                } else if ("files".equals(fieldName)) {
                    List<SearchIndexerKnowledgeStoreFileProjectionSelector> files = reader
                        .readArray(reader1 -> SearchIndexerKnowledgeStoreFileProjectionSelector.fromJson(reader1));
                    deserializedSearchIndexerKnowledgeStoreProjection.files = files;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchIndexerKnowledgeStoreProjection;
        });
    }
}
