// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Defines a specific configuration to be used in the context of semantic capabilities.
 */
@Fluent
public final class SemanticConfiguration implements JsonSerializable<SemanticConfiguration> {
    /*
     * The name of the semantic configuration.
     */
    @Generated
    private final String name;

    /*
     * Describes the title, content, and keyword fields to be used for semantic ranking, captions, highlights, and
     * answers. At least one of the three sub properties (titleField, prioritizedKeywordsFields and
     * prioritizedContentFields) need to be set.
     */
    @Generated
    private final SemanticPrioritizedFields prioritizedFields;

    /*
     * Specifies the score type to be used for the sort order of the search results.
     */
    @Generated
    private RankingOrder rankingOrder;

    /*
     * Determines which semantic or query rewrite models to use during model flighting/upgrades.
     */
    @Generated
    private Boolean flightingOptIn;

    /**
     * Creates an instance of SemanticConfiguration class.
     * 
     * @param name the name value to set.
     * @param prioritizedFields the prioritizedFields value to set.
     */
    @Generated
    public SemanticConfiguration(String name, SemanticPrioritizedFields prioritizedFields) {
        this.name = name;
        this.prioritizedFields = prioritizedFields;
    }

    /**
     * Get the name property: The name of the semantic configuration.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the prioritizedFields property: Describes the title, content, and keyword fields to be used for semantic
     * ranking, captions, highlights, and answers. At least one of the three sub properties (titleField,
     * prioritizedKeywordsFields and prioritizedContentFields) need to be set.
     * 
     * @return the prioritizedFields value.
     */
    @Generated
    public SemanticPrioritizedFields getPrioritizedFields() {
        return this.prioritizedFields;
    }

    /**
     * Get the rankingOrder property: Specifies the score type to be used for the sort order of the search results.
     * 
     * @return the rankingOrder value.
     */
    @Generated
    public RankingOrder getRankingOrder() {
        return this.rankingOrder;
    }

    /**
     * Set the rankingOrder property: Specifies the score type to be used for the sort order of the search results.
     * 
     * @param rankingOrder the rankingOrder value to set.
     * @return the SemanticConfiguration object itself.
     */
    @Generated
    public SemanticConfiguration setRankingOrder(RankingOrder rankingOrder) {
        this.rankingOrder = rankingOrder;
        return this;
    }

    /**
     * Get the flightingOptIn property: Determines which semantic or query rewrite models to use during model
     * flighting/upgrades.
     * 
     * @return the flightingOptIn value.
     */
    @Generated
    public Boolean isFlightingOptIn() {
        return this.flightingOptIn;
    }

    /**
     * Set the flightingOptIn property: Determines which semantic or query rewrite models to use during model
     * flighting/upgrades.
     * 
     * @param flightingOptIn the flightingOptIn value to set.
     * @return the SemanticConfiguration object itself.
     */
    @Generated
    public SemanticConfiguration setFlightingOptIn(Boolean flightingOptIn) {
        this.flightingOptIn = flightingOptIn;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("prioritizedFields", this.prioritizedFields);
        jsonWriter.writeStringField("rankingOrder", this.rankingOrder == null ? null : this.rankingOrder.toString());
        jsonWriter.writeBooleanField("flightingOptIn", this.flightingOptIn);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SemanticConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SemanticConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SemanticConfiguration.
     */
    @Generated
    public static SemanticConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean prioritizedFieldsFound = false;
            SemanticPrioritizedFields prioritizedFields = null;
            RankingOrder rankingOrder = null;
            Boolean flightingOptIn = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("prioritizedFields".equals(fieldName)) {
                    prioritizedFields = SemanticPrioritizedFields.fromJson(reader);
                    prioritizedFieldsFound = true;
                } else if ("rankingOrder".equals(fieldName)) {
                    rankingOrder = RankingOrder.fromString(reader.getString());
                } else if ("flightingOptIn".equals(fieldName)) {
                    flightingOptIn = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && prioritizedFieldsFound) {
                SemanticConfiguration deserializedSemanticConfiguration
                    = new SemanticConfiguration(name, prioritizedFields);
                deserializedSemanticConfiguration.rankingOrder = rankingOrder;
                deserializedSemanticConfiguration.flightingOptIn = flightingOptIn;

                return deserializedSemanticConfiguration;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!prioritizedFieldsFound) {
                missingProperties.add("prioritizedFields");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
